<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Staff extends CI_Controller{
	
	function __construct(){
		parent::__construct();
		
		$this->load->model('staff_m');
		$this->load->library('forminput');	
		$this->load->library('form_validation');
		$this->load->library('form_engine');
		$this->load->library('Querylib');
		$this->load->library('datatables');
		$this->load->library('email');
		//$this->load->module("users");
		
		//if(!$this->users->_is_admin()){
			//show_404();
		//}
		
	}
	
	function index(){
		
		if($this->session->userdata('staff_ssn')){
    	
			$session_data = $this->session->userdata('staff_ssn');			
			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Staff Home',
				'keywords' => 'Staff Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;			
			$this->load->view('dashboard',$data);
						
    	}else{
      		//If no session, redirect to login page
      		redirect('staff/login', 'refresh');
		}
		
	}

	public function timesheet(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getslot'] = $this->staff_m->gettimeslot();
			$data['gettasks'] = $this->staff_m->get_stafftasks($session_data['id']);
			$data['gettimesheet'] = $this->staff_m->get_timesheet($session_data['id']);

			$this->load->view('timetask/list', $data);
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	public function addtimesheet(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getslot'] = $this->staff_m->gettimeslot();
			$data['getstatus'] = $this->staff_m->gettaskstatus();
			$data['gettasks'] = $this->staff_m->get_stafftasks($session_data['id']);
			$data["newpatient_database"] = 'staff/new_tasks_data';
			$this->load->view('timetask/add', $data);
		}else{
			redirect('staff/login', 'refresh');
		}
	}


	public function new_tasks_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('staff_ssn');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'timeslot', 'label'   => 'Time Slot', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'jobfunction_id', 'label'   => 'Task', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'staff_id' => $session_data['id'],
					'timeslot'=>$this->input->post('timeslot'),
					'jobfunction_id'=>$this->input->post('jobfunction_id'),
					'status'=>$this->input->post('status'),
					'note'=>$this->input->post('note'),
					'ip'=>$this->getRealUserIp(),
					'added_datetime'=>date('Y-m-d H:i:s'),
				);
				//Transfering data to Model
				$id = $this->staff_m->timesheet_insert($data);

				$datahistory = array(
					'timesheet_id' => $id,
					'staff_id' => $session_data['id'],
					'timeslot'=>$this->input->post('timeslot'),
					'jobfunction_id'=>$this->input->post('jobfunction_id'),
					'status'=>$this->input->post('status'),
					'note'=>$this->input->post('note'),
					'ip'=>$this->getRealUserIp(),
					'added_datetime'=>date('Y-m-d H:i:s'),
				);

				$tshid = $this->staff_m->timesheethistory_insert($datahistory);

				echo $errors_array.'Added Successfully';		
		}
	}

	public function previoustasks(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getslot'] = $this->staff_m->gettimeslot();
			$data['gettasks'] = $this->staff_m->get_stafftasks($session_data['id']);
			$data['gettimesheet'] = $this->staff_m->get_timesheet($session_data['id']);

			$this->load->view('timetask/previoslist', $data);
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	public function get_predata(){  
		$session_data = $this->session->userdata('staff_ssn');
		$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',					
			);
		$data["metadata"] = $metadata;
	    $ptdata = $this->input->post('ptdata');
		$data['gettimesheet'] = $this->staff_m->get_timesheetfilter($session_data['id'],$ptdata);
		$data["slctdt"] = $ptdata;
		$this->load->view('timetask/pre_data',$data);			
	}

	public function task_dtl(){  
     	$mbrid = $this->input->post('id');		
		$data["taskdtl"] = $this->staff_m->get_timesheetdts($mbrid);
		$this->load->view('timetask/taskdtl',$data);			
	}//end function
	
	public function task_upt(){  
     	$mbrid = $this->input->post('id');		
		$data["taskdtl"] = $this->staff_m->get_timesheetdts($mbrid);
		$data['getstatus'] = $this->staff_m->gettaskstatus();
		$data["taskdata"] = $this->staff_m->get_timesheetid($mbrid);
		$data["newpatient_database"] = 'staff/edit_timesheet/'.$mbrid;
		$this->load->view('timetask/update',$data);			
	}//end function

	 public function edit_timesheet($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('staff_ssn');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'status', 'label'   => 'Status', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'note'=>$this->input->post('note'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$this->staff_m->timesheet_update($id,$data);

				$datahistory = array(
					'timesheet_id' => $id,
					'staff_id' => $session_data['id'],
					'timeslot'=>$this->input->post('timeslot'),
					'jobfunction_id'=>$this->input->post('jobfunction_id'),
					'status'=>$this->input->post('status'),
					'note'=>$this->input->post('note'),
					'ip'=>$this->getRealUserIp(),
					'added_datetime'=>date('Y-m-d H:i:s'),
				);

				$tshid = $this->staff_m->timesheethistory_insert($datahistory);

				echo $errors_array.'Update Successfully';
		}
	}

	public function marketing($type){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['type'] = $type;
			$data['getmedia'] = $this->staff_m->get_media();
			$data['gettodaymkt'] = $this->staff_m->get_todaymkt($session_data['id'],$type);
			if (empty($data['gettodaymkt'])) {
				$data["newpatient_database"] = 'staff/new_marketing_data';
				$this->load->view('marketing/add', $data);
			}else{
				$data["newpatient_database"] = 'staff/new_marketing_edit';
				$this->load->view('marketing/update', $data);
			}

			
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	public function new_marketing_data(){
		$session_data = $this->session->userdata('staff_ssn');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'mkttype', 'label'   => 'Type', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{

        	$medialst = $this->staff_m->get_media();

			if (!empty($medialst)) {
				foreach($medialst as $mlst){
					$tv = $this->input->post('totalrcv'.$mlst->media_id);
					if (empty($tv)) {
						$ttlv = 0;
					}else{
						$ttlv = $tv;
					}
					$tdata = array(
						'staff_id' => $session_data['id'],
						'media_id' => $mlst->media_id,
						'total' => $ttlv,
						'remark' => $this->input->post('remarks'.$mlst->media_id),
						'mkt_type' => $this->input->post('mkttype'),
						'mkt_date' => date('Y-m-d'),
						'added_datetime' => date('Y-m-d H:i:s'),
					);
					$this->staff_m->mkt_insert($tdata);
				}
			}

			echo $errors_array.'Added Successfully';		
		}
	}

	public function new_marketing_edit(){
		$session_data = $this->session->userdata('staff_ssn');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'mkttype', 'label'   => 'Type', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{

        	$mkttype = $this->input->post('mkttype');

        	$medialst = $this->staff_m->get_todaymkt($session_data['id'],$mkttype);
			if (!empty($medialst)) {
				foreach($medialst as $mlst){
					$tv = $this->input->post('totalrcv'.$mlst->mkt_id);
					$mktid = $this->input->post('mktid'.$mlst->mkt_id);					
					$tdata = array(
						'total' => $tv,
						'remark' => $this->input->post('remarks'.$mlst->mkt_id),
					);
					$this->staff_m->mkt_update($mktid,$tdata);
				}
			}

			echo $errors_array.'Added Successfully';		
		}
	}

	public function marketingdata($type){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['type'] = $type;
			$data['getmedia'] = $this->staff_m->get_media();
			$data['gettodaymkt'] = $this->staff_m->get_todaymkt($session_data['id'],$type);
			$this->load->view('marketing/mktlist', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	public function get_premktdata(){  
		$session_data = $this->session->userdata('staff_ssn');
		$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',					
			);
		$data["metadata"] = $metadata;
	    $ptdate = $this->input->post('ptdata');
	    $mktype = $this->input->post('mtp');
		$data['getmkt'] = $this->staff_m->get_mktfilterbydate($session_data['id'],$ptdate,$mktype);
		$data["slctdt"] = $ptdate;
		$data["mkt"] = $mktype;
		$this->load->view('marketing/mkt_filter',$data);			
	}

	public function quotations(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Time Sheet',
				'description' => 'Time Sheet',
				'keywords' => 'Time Sheet',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getmedia'] = $this->staff_m->get_media();
			$data["newpatient_database"] = 'staff/new_quotation_data';
			$this->load->view('quotation/add', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	public function new_quotation_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('staff_ssn');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'customer_name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'customer_phone', 'label'   => 'Phone', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'staff_id' => $session_data['id'],
					'customer_name'=>$this->input->post('customer_name'),
					'customer_phone'=>$this->input->post('customer_phone'),
					'customer_email'=>$this->input->post('customer_email'),					
					'added_datetime'=>date('Y-m-d H:i:s'),
				);
				//Transfering data to Model
				$id = $this->staff_m->customer_insert($data);

				$quotdata = array(
					'customer_id' => $id,
					'staff_id' => $session_data['id'],
					'description'=>$this->input->post('description'),
					'qt_date'=>date('Y-m-d'),
					'added_datetime'=>date('Y-m-d H:i:s'),
				);

				$tshid = $this->staff_m->quotation_insert($quotdata);

				echo $errors_array.'Added Successfully';		
		}
	}


	public function quotationlist(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Quatation',
				'heading' => 'Quatation',
				'description' => 'Quatation',
				'keywords' => 'Quatation',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getquotation'] = $this->staff_m->get_quotation($session_data['id']);
			$this->load->view('quotation/list', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	}

	function dealcloss(){
         $id = $_POST["id"];
         $aptdata = array(
				'deal_status'=>1,
				'closs_datetime'=>date('Y-m-d H:i:s'),
			);
		 //Transfering data to Model
		 $this->staff_m->clossdeal($id,$aptdata);          
         echo 'Deal has been changed';  
    }

	public function postinglist(){
		if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Post',
				'heading' => 'Post',
				'description' => 'Post',
				'keywords' => 'Post',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getposting'] = $this->staff_m->get_postinglist($session_data['id']);
			$this->load->view('marketing/postinglist', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	}

public function addposting(){
	if ($this->session->userdata('staff_ssn')) {
			$session_data = $this->session->userdata('staff_ssn');
			$metadata = array(
				'title' => 'Post',
				'heading' => 'Post',
				'description' => 'Post',
				'keywords' => 'Post',
				'id' => $session_data['id'],
				'user_login' => $session_data['staff_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['staff_title'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getmedia'] = $this->staff_m->get_media();
			$data['getposting'] = $this->staff_m->get_postinglist($session_data['id']);
			$data["save_database"] = 'staff/new_posting_data';
			$this->load->view('marketing/postingadd', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
}

public function new_posting_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('staff_ssn');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'media_id', 'label'   => 'Media', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'post_title', 'label'   => 'Post Title', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'post_type', 'label'   => 'Post Type', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'post_date', 'label'   => 'Post Date', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'staff_id' => $session_data['id'],
					'media_id'=>$this->input->post('media_id'),
					'post_title'=>$this->input->post('post_title'),
					'post_type'=>$this->input->post('post_type'),
					'post_date'=>$this->input->post('post_date'),					
					'post_datetime'=>date('Y-m-d H:i:s'),
				);
				//Transfering data to Model
				$id = $this->staff_m->post_insert($data);

				echo $errors_array.'Added Successfully';		
		}
	}




	
	function login(){  
     	$this->load->view('login');
     	/*$this->load->view('maintenance');	*/
	}//end function

	
	public function verifylogin(){  
    	
		$username = $this->input->post('username');
		$password = $this->input->post('password');
				
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'username', 		'label'   => 'Email',				'rules'   => 'trim|xss_clean|required|valid_email'),
				array('field'   => 'password', 		'label'   => 'Password',				'rules'   => 'trim|xss_clean|required'),
								  
        );
				
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{			
			
			$password= sha1($password);
			$result = $this->staff_m->login($username, $password);
			
			if($result){		
				$sess_array = array();
				foreach($result as $row){
					$sess_array = array(
						'id' => $row->staff_id,
						'staff_login' => $row->staff_email,
						'display_name' => $row->staff_name,
						'user_image' => $row->staff_photo,
						'staff_title' => $row->staff_designation,
						'staff_phone' => $row->staff_contact_no,
						);
					$this->session->set_userdata('staff_ssn', $sess_array);
				}
				echo $errors_array.'Login Successfully';
				//for user login log
				/*$user_note_date = $this->config->item('CUR_D_T');*/
				$session_data = $this->session->userdata('staff_ssn');
				$userid = $session_data['id'];
				$user_note_date = date('Y-m-d H:i:s');
				$user_note = 'In '.$user_note_date;
				$user_log_data = array(
					'Staff_id' => $userid,
					'Staff_Login' => $username,
					'Login_Note' => 'In',
					'Date_Time' => $user_note_date,
					'Staff_ip' => $this->input->post('lip'),
				);
				$this->staff_m->user_log($user_log_data);
				//end user login log
			}else{
				echo $errors_array.'Invalid username or password';
			}
												
		}
			
	}//end function

	function regi(){  
     	$this->load->view('regi');
	}//end function

	public function aptadd(){  
				
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label' => 'User Name', 'rules' => 'trim|xss_clean|required'),								  
        );
				
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
			echo $errors_array.'Login Successfully';												
		}
			
	}//end function
	
	
	function check_database($password){
  
		//Field validation succeeded.  Validate against database
		$username = $this->input->post('username');
		$password= md5($password);
		
		// $type = $this->input->post('type');
		//query the database
		$result = $this->staff_m->login($username, $password);
		
		if($result){		
			$sess_array = array();
			foreach($result as $row){
				$sess_array = array(
					'id' => $row->user_id,
					'user_login' => $row->user_login,
					'display_name' => $row->display_name,
					'user_image' => $row->User_Image,
					'user_type' => $row->user_type
					);
				$this->session->set_userdata('staff_ssn', $sess_array);
			}
			return TRUE;
		}else{
			$this->form_validation->set_message('check_database', 'Invalid username, password or Type');
			return false;
		}
		
  	}//end function
		
	
	function logout(){
		$this->session->unset_userdata('logged_in');
		
		$session_data = $this->session->userdata('staff_ssn');
		$userid = $session_data['id'];
		$username = $session_data['staff_login'];
		/*$user_note_date = $this->config->item('CUR_D_T');*/

		$user_note_date = date('Y-m-d H:i:s');
		$user_note = 'Out '.$user_note_date;
		$user_log_data = array(
					'Staff_id' => $userid,
					'Staff_Login' => $username,
					'Login_Note' => 'Out',
					'Date_Time' => $user_note_date,
					'Staff_ip' => $this->getRealUserIp(),
				);
		$this->staff_m->user_log($user_log_data);
		session_destroy();
		redirect(base_url('home') , 'refresh');
	}

	function getRealUserIp(){
		switch(true){
			case (!empty($_SERVER['HTTP_X_REAL_IP'])) : return $_SERVER['HTTP_X_REAL_IP'];
			case (!empty($_SERVER['HTTP_CLIENT_IP'])) : return $_SERVER['HTTP_CLIENT_IP'];
			case (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) : return $_SERVER['HTTP_X_FORWARDED_FOR'];
			default : return $_SERVER['REMOTE_ADDR'];
		}
	}

	function clearcache(){    	
		$this->output->clear_all_cache();
		redirect('admin', 'refresh');		
  	} //End of function

	
	
	function profile(){
		//print_r($this->session->userdata('staff_ssn'));exit;
		if($this->session->userdata('staff_ssn')){
    	
			$session_data = $this->session->userdata('staff_ssn');			
			$metadata = array(
				'title' => 'Profile',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;
			
			$userid=$session_data['id'];
			$data["profile_data"] = $this->staff_m->get_userprofile($userid);			
			$this->load->view('profile',$data);
						
    	}else{
      		//If no session, redirect to login page
      		redirect('admin/login', 'refresh');
		}
		
	}
	
	function profile_update(){
		$session_data = $this->session->userdata('staff_ssn');			
		$metadata = array(
			'title' => 'Profile',
			'heading' => 'Profile',
			'description' => 'Admin Home',
			'keywords' => 'Admin Home',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'page' => 'post',				
			);
		$data["metadata"] = $metadata;
		$user_group = $this->staff_m->get_usergroup();
		foreach($user_group as $row){
			$data['groupes'][$row->Usergroup_Id]=$row->Usergroup_Head;
		}
		$data["groupes"] = $data['groupes'];
		$userid=$session_data['id'];
		$data["profile_data"] = $this->staff_m->get_userprofile($userid);	
		$data["updateform_database"] = 'admin/update_user_data';					
		$this->load->view('userupdate', $data);
	}
	
	
	public function update_user_data($userid){		
		//$this->is_ajax();
		
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'Usergroup_Id', 'label'   => 'User Group', 'rules'   => 'trim|xss_clean|required'),
				//array('field'   => 'User_Login', 'label'   => 'User Name', 'rules'   => 'trim|xss_clean|required'),
				array('field'   => 'Display_Name', 'label'   => 'Display Name', 'rules'   => 'trim|xss_clean|required'),
				
        );
		
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{	
		  //Setting values for tabel columns
		  $data = array(
			
			'Usergroup_Id' => $this->input->post('Usergroup_Id'),
			//'User_Login' => $this->input->post('User_Login'),
			'Display_Name' => $this->input->post('Display_Name'),
			'Contact_No' => $this->input->post('Contact_No'),
			'User_Email' => $this->input->post('User_Email'),
			'User_Address' => $this->input->post('User_Address'),
			//'User_Image' => $image_name,
					  
		  );
		  //Transfering data to Model
		  $this->staff_m->user_update($userid,$data);
		  if(!empty($_FILES["uploadfile"]["name"])){		
					$path=APPPATH.'../user/images/users';
					$userfile_name = $_FILES['uploadfile']['name'];
					$extension = substr($userfile_name, strrpos($userfile_name, '.')+1);
					
					$image_name = 'admin'. '-' . rand().'.'.$extension;
					$file = $path .'/'.$image_name; 								
					move_uploaded_file($_FILES['uploadfile']['tmp_name'], $file) ;
					
					$data = array(				
							'User_Image' => $image_name,
						);
						$this->staff_m->user_update($userid,$data);
				}
		  if(!empty($this->input->post('User_Password'))){
			  $data = array(				
							'User_Password' => md5($this->input->post('User_Password')),
						);
						$this->staff_m->user_update($userid,$data);
		  }
		  
		  echo $errors_array.'Update Successfully';			
		}
		
	}


	 
		
}

?>