<?php
Class Setup_model extends CI_Model{	
	
	public function get_centerlist()
	{
		$this -> db -> select('center_id,center_name');		
		$this -> db -> order_by('center_name','ASC');
		$this -> db -> from('centers');
		$query = $this->db->get();
		return $query->result();
	}
/*--- Clinic ---*/
 public function get_center() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'clinic');
		$this->db->order_by('clinic_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function center_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'clinic', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

 public function center_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('clinic_id', $id);
		$this->db->update(DB_PREFIX.'clinic', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_centerforeid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'clinic');
		$this->db->where('clinic_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

/*--- Treatment Category ---*/
 public function get_treatmentcat() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'treatment_category');
		$this->db->order_by('category_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function treatmentcat_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'treatment_category', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

 public function treatmentcat_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('category_id', $id);
		$this->db->update(DB_PREFIX.'treatment_category', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_treatmentcatid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'treatment_category');
		$this->db->where('category_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

/*--- Treatment Type ---*/
 public function get_treatmenttype() { 
       	$this -> db -> select('t1.*, t2.category_name');
		$this -> db -> from(DB_PREFIX.'treatment_type t1');
		$this -> db -> join(DB_PREFIX.'treatment_category t2', 't2.category_id = t1.treatment_category', 'left');
		$this->db->order_by('treatment_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function treatmenttype_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'treatment_type', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

 public function treatmenttype_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('treatment_id', $id);
		$this->db->update(DB_PREFIX.'treatment_type', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_treatmenttypeid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'treatment_type');
		$this->db->where('treatment_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

 /*--- Staff Category ---*/
 public function get_staffcat() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'staff_category');
		$this->db->order_by('category_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function staffcat_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'staff_category', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

 public function staffcat_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('cat_id', $id);
		$this->db->update(DB_PREFIX.'staff_category', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_staffcatid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'staff_category');
		$this->db->where('cat_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 
 /*--- Staff ---*/
 public function get_staff() { 
       	$this->db->select('t1.*, t2.category_name');
       	$this->db->from(DB_PREFIX.'staff t1');
		$this->db->join(DB_PREFIX.'staff_category t2', 't2.cat_id = t1.staff_category', 'left');
		$this->db->order_by('t1.staff_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function staff_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'staff', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

public function get_staffid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'staff');
		$this->db->where('staff_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

  public function staff_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('staff_id', $id);
		$this->db->update(DB_PREFIX.'staff', $data);				
		$this->db->trans_complete();					
   	} // End of function 
    
/*--- Appointment Time Slot ---*/
 public function get_timeslot() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'timeslot');
		$this->db->order_by('slot_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

 public function timeslot_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'timeslot', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

 public function timeslot_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('slot_id', $id);
		$this->db->update(DB_PREFIX.'timeslot', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_timeslotid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'timeslot');
		$this->db->where('slot_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 



/*--- User Group ---*/

public function get_usergroup(){
	$this->db->select('*');
	$this->db->from(DB_PREFIX.'admin_user_group');
	$this->db->order_by('Usergroup_Head', 'ASC');
	$query = $this->db->get();
	return $query->result();
}

public function check_usergroup($ugroup_name){		
		$this -> db -> select('Usergroup_Id');
		$this -> db -> from(DB_PREFIX.'admin_user_group');
		$this -> db -> where('Usergroup_Head = ' . "'" . $ugroup_name . "'"); 
		$query = $this->db->get();				
		if ($query->num_rows() > 0) {
			$row = $query->row();
        	return $row->Usergroup_Id;
		}
		return 0;
	
	}// End function
public function usergroup_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'admin_user_group', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

public function usergroup_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('Usergroup_Id', $id);
		$this->db->update(DB_PREFIX.'admin_user_group', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_usergroupid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'admin_user_group');
		$this->db->where('Usergroup_Id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 


/*--- Admin User ---*/

public function get_adminuser(){
	$this->db->select('t1.*, t2.Usergroup_Head');
	$this->db->from(DB_PREFIX.'admin_user t1');
	$this->db->join(DB_PREFIX.'admin_user_group t2','t2.Usergroup_Id = t1.Usergroup_Id', 'left');
	$this->db->order_by('t1.User_Login', 'ASC');
	$query = $this->db->get();
	return $query->result();
}

public function getusergroup(){
	$this->db->select('*');
	$this->db->from(DB_PREFIX.'admin_user_group');
	$this->db->where('UsergroupStatus', 1);
	$this->db->order_by('Usergroup_Head', 'ASC');
	$query = $this->db->get();
	return $query->result();
}

public function check_adminuser($ugroup_name){		
		$this -> db -> select('Usergroup_Id');
		$this -> db -> from(DB_PREFIX.'admin_user');
		$this -> db -> where('Usergroup_Head = ' . "'" . $ugroup_name . "'"); 
		$query = $this->db->get();				
		if ($query->num_rows() > 0) {
			$row = $query->row();
        	return $row->Usergroup_Id;
		}
		return 0;
	
	}// End function
public function adminuser_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'admin_user', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

public function adminuser_update($data, $id) {
	        //Transfering data to Model
		 $this->db->trans_start();
		 $this->db->where('Admin_Id', $id);
		 $this->db->update(DB_PREFIX.'admin_user', $data);				
		 $this->db->trans_complete();					
   	} // End of function 

 public function get_adminuserid($cid) { 
       $this->db->select('t1.*, t2.Usergroup_Head, t3.clinic_name');
	$this->db->from(DB_PREFIX.'admin_user t1');
	$this->db->join(DB_PREFIX.'admin_user_group t2','t2.Usergroup_Id = t1.Usergroup_Id', 'left');
	$this->db->join(DB_PREFIX.'clinic t3','t3.clinic_id = t1.Clinic_Id', 'left');
	$this->db->where('t1.Admin_Id', $cid);
	$query = $this->db->get();
	return $query->first_row();
    } // End of function 

/*--- Media ---*/
 public function get_media() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'media');
		$this->db->order_by('media_name','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

public function media_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'media', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function
   	
public function media_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('media_id', $id);
		$this->db->update(DB_PREFIX.'media', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_mediaid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'media');
		$this->db->where('media_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 


/*--- Job Function ---*/
 public function get_jobfunction() { 
       	$this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'jobfunction');
		$this->db->order_by('jf_title','ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

public function jobfunction_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'jobfunction', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function
   	
public function jobfunction_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('jf_id', $id);
		$this->db->update(DB_PREFIX.'jobfunction', $data);				
		$this->db->trans_complete();					
   	} // End of function 

 public function get_jobfunctionid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'jobfunction');
		$this->db->where('jf_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 
public function get_tasksforstaff() {
        $this->db->select('*');
		$this->db->from(DB_PREFIX.'jobfunction');
		$this->db->where('status', 1);
		$this->db->order_by('jf_title', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function
public function staffjob_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'staffjob', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

public function get_stafftasks($sid) {
       $this->db->select('t1.*,t2.jf_title');
	$this->db->from(DB_PREFIX.'staffjob t1');
	$this->db->join(DB_PREFIX.'jobfunction t2','t2.jf_id = t1.job_id', 'left');
	$this->db->where('t1.staff_id', $sid);
	$this->db->order_by('t2.jf_title', 'ASC');
	$query = $this->db->get();
	return $query->result();
    } // End of function 
public function staffjob_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('sj_id', $id);
		$this->db->update(DB_PREFIX.'staffjob', $data);				
		$this->db->trans_complete();					
   	} // End of function

public function check_staffjob($sid,$jfid){		
		$this -> db -> select('sj_id');
		$this -> db -> from(DB_PREFIX.'staffjob');
		$this -> db -> where('staff_id = ' . "'" . $sid . "'"); 
		$this -> db -> where('job_id = ' . "'" . $jfid . "'"); 
		$query = $this->db->get();				
		if ($query->num_rows() > 0) {
			$row = $query->row();
        	return $row->sj_id;
		}
		return 0;
	
	}// End function
	
}//end of Class 
?>