<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Setup extends Ci_Controller {
	
	function __construct(){  	
		parent::__construct();
		
		if($this->session->userdata('tms_ssndata')){
			$this->load->model('Setup_model');			
			$this->load->library('tags');
			$this->load->library('imagecrop');			
			$this->load->library('forminput');			
			$this->load->library('form_validation');			
			$this->load->library('datatables');
			$this->load->library('Querylib');
        		$this->load->library('table');	
			$this->load->library('form_engine');
			$this->load->library('upload');
					
		}else{
			//If no session, redirect to login page
			redirect('admin/login', 'refresh');
		}		
  	}

  	/*--------- center -------*/
  	public function center(){
		
		$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["centerlist"] = $this->Setup_model->get_center();

		$this->load->view('clinic/list', $data);
		
	}

	function addcenter(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_center_data';
		/*print_r($data['countpatient']);exit;*/
		
         $this->load->view('clinic/add', $data);
     }

     public function new_center_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'email', 'label'   => 'Email Address', 'rules'   => 'valid_email', 'errors'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'clinic_name'=>$this->input->post('name'),
					'clinic_code'=>$this->input->post('code'),
					'clinic_address'=>$this->input->post('address'),
					'status'=>$this->input->post('status'),
					'clinic_phone'=>$this->input->post('clinic_phone'),
					'clinic_email'=>$this->input->post('clinic_email')
				);
				//Transfering data to Model
				$id = $this->Setup_model->center_insert($data);
				echo $errors_array.'Added Successfully';						
			
		}
	}

	function editcenter($id){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_center_data/'.$id;
		$data["info"] = $this->Setup_model->get_centerforeid($id);
		
         $this->load->view('clinic/edit', $data);
     }

     public function edit_center_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'clinic_name'=>$this->input->post('name'),
					'clinic_code'=>$this->input->post('code'),
					'clinic_address'=>$this->input->post('address'),
					'status'=>$this->input->post('status'),
					'clinic_phone'=>$this->input->post('clinic_phone'),
					'clinic_email'=>$this->input->post('clinic_email')
				);

				//Transfering data to Model
				$this->Setup_model->center_update($data, $id);
				
				echo $errors_array.'Update Successfully';
						
			
		}
	}
/*---- end center ----*/

/*---- treatment category ----*/
public function treatmentcat(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treatcatlist"] = $this->Setup_model->get_treatmentcat();

		$this->load->view('treatment_cat/list', $data);

}
function addtreatmentcat(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_treatmentcat_data';
		
         $this->load->view('treatment_cat/add', $data);
     }

 public function new_treatmentcat_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'category_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->treatmentcat_insert($data);
				echo $errors_array.'Added Successfully';						
			
		}
	}

function edittreatmentcat($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_treatment_data/'.$id;
		$data["info"] = $this->Setup_model->get_treatmentcatid($id);
		
         $this->load->view('treatment_cat/edit', $data);
     }

 public function edit_treatment_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'category_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);

				//Transfering data to Model
				$this->Setup_model->treatmentcat_update($data, $id);
				
				echo $errors_array.'Update Successfully';
						
			
		}
	}



/*---- End treatment category ----*/

/*---- treatment category ----*/
public function treatmenttype(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treattypelist"] = $this->Setup_model->get_treatmenttype();

		$this->load->view('treatment_type/list', $data);

}
function addtreatmenttype(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_treatmenttype_data';
		$data["treatcatlist"] = $this->Setup_model->get_treatmentcat();
		
         $this->load->view('treatment_type/add', $data);
     }

 public function new_treatmenttype_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'category', 'label'   => 'Category', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'numberof_machine', 'label'   => 'Number of Service', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'treatment_name'=>$this->input->post('name'),
					'treatment_category'=>$this->input->post('category'),
					'numberof_machine'=>$this->input->post('numberof_machine'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->treatmenttype_insert($data);
				echo $errors_array.'Added Successfully';						
			
		}
	}

function edittreatmenttype($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["editdata"] = 'setup/edit_treatmenttype_data/'.$id;
		$data["treattypelist"] = $this->Setup_model->get_treatmentcat();
		$data["info"] = $this->Setup_model->get_treatmenttypeid($id);
		
         $this->load->view('treatment_type/edit', $data);
     }

 public function edit_treatmenttype_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'category', 'label'   => 'Category', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'treatment_name'=>$this->input->post('name'),
					'treatment_category'=>$this->input->post('category'),
					'numberof_machine'=>$this->input->post('numberof_machine'),
					'status'=>$this->input->post('status'),
				);

				//Transfering data to Model
				$this->Setup_model->treatmenttype_update($data, $id);
				
				echo $errors_array.'Update Successfully';
						
			
		}
	}

/*---- End treatment category ----*/

/*---- staff category ----*/
public function staffcategory(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treatcatlist"] = $this->Setup_model->get_staffcat();
		$this->load->view('staff_department/list', $data);
}
function addstaffcategory(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_staffcat_data';		
         $this->load->view('staff_department/add', $data);
     }

 public function new_staffcat_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'category_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->staffcat_insert($data);
				echo $errors_array.'Added Successfully';		
		}
	}

function editstaffcat($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_staffcat_data/'.$id;
		$data["info"] = $this->Setup_model->get_staffcatid($id);
		
         $this->load->view('staff_department/edit', $data);
     }

 public function edit_staffcat_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'category_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$this->Setup_model->staffcat_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

/*---- End staff category ----*/


/*---- staff ----*/
public function staff(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'staff',
			'description' => '',
			'keywords' => '',
			'heading' => 'staff',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["stafflist"] = $this->Setup_model->get_staff();
		/*print_r($data["stafflist"]);exit;*/
		$this->load->view('staff/list', $data);
}
function addstaff(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'staff',
			'description' => '',
			'keywords' => '',
			'heading' => 'staff',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_staff_data';
		$data["getstaffcat"] = $this->Setup_model->get_staffcat();
		$data["getclinic"]	= $this->Setup_model->get_center();	
         $this->load->view('staff/add', $data);
     }

 public function new_staff_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'email', 'label'   => 'Staff Email', 'rules'   => 'trim|xss_clean|valid_email|is_unique[tms_staff.staff_email]|required'),
               	array('field'   => 'clinic', 'label'   => 'Clinic', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'category', 'label'   => 'Category', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'password', 'label'   => 'Password', 'rules'   => 'trim|xss_clean|required'),
		array('field'   => 'confirm_password', 'label'   => 'Confirm Password', 'rules'   => 'trim|xss_clean|required|matches[password]'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
			//Setting values for tabel columns
			$data = array(
				'staff_name'=>$this->input->post('name'),
				'staff_code'=>$this->input->post('staff_code'),
				'staff_designation'=>$this->input->post('staff_designation'),
				'staff_contact_no'=>$this->input->post('staff_contact_no'),
				'staff_email'=>$this->input->post('email'),
				'staff_category'=>$this->input->post('category'),
				'clinic'=>$this->input->post('clinic'),
				'staff_status'=>$this->input->post('status'),
				'password'=>sha1($this->input->post('password')),
				'staff_sc'=>$this->input->post('password'),
				'added_by'=>$session_data['id'],
			);

			$config['upload_path'] = 'uploads/staff/';
			$config['allowed_types']        = 'gif|jpg|png|jpeg|pdf|doc|docx|xlsx';
			$config['detect_mime']          = TRUE;
			$config['remove_spaces']        = TRUE;
			$config['encrypt_name']         = TRUE;
			$config['max_size']             = '0';
			$this->upload->initialize($config);
			if (!$this->upload->do_upload('staffimg')){
				$upload_error = $this->upload->display_errors();
			}else{
				$fileData = $this->upload->data();					
				$full_path = $fileData['full_path'];					
				$data['staff_photo'] = $fileData['file_name'];
			}

			//Transfering data to Model
			$id = $this->Setup_model->staff_insert($data);
			echo $errors_array.'Added Successfully';		
		}
	}

function editstaff($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["editdata"] = 'setup/edit_staff_data/'.$id;
		$data["info"] = $this->Setup_model->get_staffid($id);
		$data["getstaffcat"] = $this->Setup_model->get_staffcat();
		$data["getclinic"]	= $this->Setup_model->get_center();	
		
         $this->load->view('staff/edit', $data);
     }

 public function edit_staff_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'clinic', 'label'   => 'Clinic', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'category', 'label'   => 'Category', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'staff_name'=>$this->input->post('name'),
					'staff_code'=>$this->input->post('staff_code'),
					'staff_designation'=>$this->input->post('staff_designation'),
					'staff_contact_no'=>$this->input->post('staff_contact_no'),
					'staff_email'=>$this->input->post('email'),
					'staff_category'=>$this->input->post('category'),
					'clinic'=>$this->input->post('clinic'),
					'staff_status'=>$this->input->post('status'),
				);

				$config['upload_path'] = 'uploads/staff/';
				$config['allowed_types']        = 'gif|jpg|png|jpeg|pdf|doc|docx|xlsx';
				$config['detect_mime']          = TRUE;
				$config['remove_spaces']        = TRUE;
				$config['encrypt_name']         = TRUE;
				$config['max_size']             = '0';
				$this->upload->initialize($config);
				if (!$this->upload->do_upload('staffimg')){
					$upload_error = $this->upload->display_errors();
				}else{
					$fileData = $this->upload->data();					
					$full_path = $fileData['full_path'];					
					$data['staff_photo'] = $fileData['file_name'];
				}

				//Transfering data to Model
				$this->Setup_model->staff_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

function staff_pwchange($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Change Staff Password',
			'description' => '',
			'keywords' => '',
			'heading' => 'Change Password',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],			
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/staff_changepw_data/'.$id;
		$data["info"] = $this->Setup_model->get_staffid($id);		
         $this->load->view('staff/change_pw', $data);
     }

 public function staff_changepw_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'password', 'label'   => 'Password', 'rules'   => 'trim|xss_clean|required'),
				array('field'   => 'confirm_password', 'label'   => 'Confirm Password', 'rules'   => 'trim|xss_clean|required|matches[password]'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'password' => sha1($this->input->post('password')),
					'staff_sc' => $this->input->post('password'),
				);
				//Transfering data to Model
				$this->Setup_model->staff_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

function staff_jobs($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Staff Tasks',
			'description' => '',
			'keywords' => '',
			'heading' => 'Staff Tasks',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],			
		);
	$data["metadata"] = $metadata;
	$data["newpatient_database"] = 'setup/staff_job_data/'.$id;
	$data["info"] = $this->Setup_model->get_staffid($id);	
	$data['gettasks'] = $this->Setup_model->get_tasksforstaff();
	$data['stafftask'] = $this->Setup_model->get_stafftasks($id);	
        $this->load->view('staff/staff_job', $data);
     }

 public function staff_job_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
	             array('field'   => 'job_id', 'label'   => 'Task', 'rules'   => 'trim|xss_clean|required'),             	
	        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{
	        	$jid = $this->input->post('job_id');
	        	$exists = $this->Setup_model->check_staffjob($id,$jid);
			if( $exists==0 ){
			//Setting values for tabel columns
			$data = array(
				'job_id' => $this->input->post('job_id'),
				'staff_id' => $id,
				'added_datetime' => date('Y-m-d H:i:s'),
				'status' => $this->input->post('status'),
				'added_by' => $session_data['id'],
			);
			//Transfering data to Model
			$id = $this->Setup_model->staffjob_insert($data);				
			echo $errors_array.'Added Successfully';
		}else{
			echo $errors_array.'Already Added';
		}
	}
}

function staff_job_status()  
      {
         $id = $_POST["id"];
         $stssdl = $_POST["sdlstatus"];
         $aptdata = array(
				'status'=>$stssdl,
		);
	 //Transfering data to Model
	 $this->Setup_model->staffjob_update($aptdata, $id);          
         echo 'Status has been changed';  
      }
/*---- End staff ----*/

/*---- Appointment Time Slot ----*/
public function timeslot(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treatcatlist"] = $this->Setup_model->get_timeslot();
		$this->load->view('timeslot/list', $data);
}
function addtimeslot(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_timeslot_data';		
         $this->load->view('timeslot/add', $data);
     }

 public function new_timeslot_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'slot_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->timeslot_insert($data);
				echo $errors_array.'Added Successfully';		
		}
	}

function edittimeslot($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_timeslot_data/'.$id;
		$data["info"] = $this->Setup_model->get_timeslotid($id);
		
         $this->load->view('timeslot/edit', $data);
     }

 public function edit_timeslot_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'slot_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$this->Setup_model->timeslot_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

/*---- End Appointment Time Slot ----*/

/*---- Admin User Group ----*/
public function usergroup(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["grouplist"] = $this->Setup_model->get_usergroup();
		$this->load->view('user_group/list', $data);
}

public function addusergroup(){
	$session_data = $this->session->userdata('tms_ssndata');
	$metadata = array(
		'title' => 'User Group',
		'description' => '',
		'keywords' => '',
		'heading' => 'User Group',
		'imageurl' => base_url('user/images/logo.png'),
		'siteurl' => base_url(''),
		'id' => $session_data['id'],
		'user_login' => $session_data['user_login'],
		'display_name' => $session_data['display_name'],
		'user_type' => $session_data['user_type'],
	);

	$data["metadata"] = $metadata;
	$data['newpatient_database'] = 'setup/new_usergroup_data';
	$this->load->view('user_group/add', $data);


}

public function new_usergroup_data(){		
		//$this->is_ajax();
			
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'User Group Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{			
			$ugroup_name = $this->input->post('name');			
			$exists = $this->Setup_model->check_usergroup($ugroup_name);	
			/*print_r($exists);exit;	*/	
			if( $exists==0 ){ 
				
				//Setting values for tabel columns
				$data = array(
					'Usergroup_Head' => $ugroup_name,
					'UsergroupStatus' => $this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->usergroup_insert($data);
				echo $errors_array.'Added Successfully';
			}else
				echo $errors_array.'User Group Exists';
			
		}
	}

function editusergroup($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'User Group',
			'description' => '',
			'keywords' => '',
			'heading' => 'User Group',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],			
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_usergroup_data/'.$id;
		$data["info"] = $this->Setup_model->get_usergroupid($id);
		
         $this->load->view('user_group/edit', $data);
     }

 public function edit_usergroup_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'Usergroup_Head' => $this->input->post('name'),
					'UsergroupStatus' => $this->input->post('status'),
				);
				//Transfering data to Model
				$this->Setup_model->usergroup_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}
/**===== End User Group =====**/

/*---- Admin User Group ----*/
public function adminuser(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'User',
			'description' => '',
			'keywords' => '',
			'heading' => 'User',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'user',				
			);
		$data["metadata"] = $metadata;
		$data["userlist"] = $this->Setup_model->get_adminuser();
		$this->load->view('user/list', $data);
}

public function addadminuser(){
	$session_data = $this->session->userdata('tms_ssndata');
	$metadata = array(
		'title' => 'User',
		'description' => '',
		'keywords' => '',
		'heading' => 'User',
		'imageurl' => base_url('user/images/logo.png'),
		'siteurl' => base_url(''),
		'id' => $session_data['id'],
		'user_login' => $session_data['user_login'],
		'display_name' => $session_data['display_name'],
		'user_type' => $session_data['user_type'],
	);

	$data["metadata"] = $metadata;
	$data['newpatient_database'] = 'setup/new_adminuser_data';
	$data['getusergroup'] = $this->Setup_model->getusergroup();
	$data['getclinic'] = $this->Setup_model->get_center();
	$this->load->view('user/add', $data);


}

public function new_adminuser_data(){		
		//$this->is_ajax();
			
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'User Name', 'rules'   => 'trim|xss_clean|is_unique[tms_admin_user.User_Login]|required'),
               	array('field'   => 'clinic', 'label'   => 'Clinic', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'category', 'label'   => 'User Group', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'fullname', 'label'   => 'Full Name', 'rules'   => 'trim|xss_clean|required'),
               	array('field'   => 'Contact_No', 'label'   => 'Contact No', 'rules'   => 'trim|xss_clean|is_unique[tms_admin_user.Contact_No]|required'),
               	array('field'   => 'User_Email', 'label'   => 'User Email', 'rules'   => 'trim|xss_clean|valid_email|is_unique[tms_admin_user.User_Email]|required'),
		array('field'   => 'password', 'label'   => 'Password', 'rules'   => 'trim|xss_clean|required'),
		array('field'   => 'confirm_password', 'label'   => 'Confirm Password', 'rules'   => 'trim|xss_clean|required|matches[password]'),

        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{
			//Setting values for tabel columns
			$data = array(
				'Usergroup_Id' => $this->input->post('category'),
				'Clinic_Id' => $this->input->post('clinic'),
				'User_Login' => $this->input->post('name'),
				'Display_Name' => $this->input->post('fullname'),
				'Contact_No' => $this->input->post('Contact_No'),
				'User_Email' => $this->input->post('User_Email'),
				'User_Gender' => $this->input->post('gender'),
				'User_Address' => $this->input->post('User_Address'),
				'User_Password' => md5($this->input->post('password')),
				'User_Status' => $this->input->post('status'),
			);
			//Transfering data to Model
			$id = $this->Setup_model->adminuser_insert($data);
			echo $errors_array.'Added Successfully';
		}
	}

function editadminuser($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'User',
			'description' => '',
			'keywords' => '',
			'heading' => 'User',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],			
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_adminuser_data/'.$id;
		$data["info"] = $this->Setup_model->get_adminuserid($id);
		$data['getusergroup'] = $this->Setup_model->getusergroup();
		$data['getclinic'] = $this->Setup_model->get_center();
		
         $this->load->view('user/edit', $data);
     }

 public function edit_adminuser_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'Usergroup_Id' => $this->input->post('category'),
					'Clinic_Id' => $this->input->post('clinic'),
					'User_Login' => $this->input->post('name'),
					'Display_Name' => $this->input->post('fullname'),
					'Contact_No' => $this->input->post('Contact_No'),
					'User_Email' => $this->input->post('User_Email'),
					'User_Gender' => $this->input->post('gender'),
					'User_Address' => $this->input->post('User_Address'),
					'User_Status' => $this->input->post('status'),
				);
				//Transfering data to Model
				$this->Setup_model->adminuser_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

function adminuser_pwchange($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Change Password',
			'description' => '',
			'keywords' => '',
			'heading' => 'Change Password',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],			
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/changepw_data/'.$id;
		$data["info"] = $this->Setup_model->get_adminuserid($id);
		$data['getusergroup'] = $this->Setup_model->getusergroup();
		$data['getclinic'] = $this->Setup_model->get_center();
		
         $this->load->view('user/change_pw', $data);
     }

 public function changepw_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'password', 'label'   => 'Password', 'rules'   => 'trim|xss_clean|required'),
				array('field'   => 'confirm_password', 'label'   => 'Confirm Password', 'rules'   => 'trim|xss_clean|required|matches[password]'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'User_Password' => md5($this->input->post('password')),
				);
				//Transfering data to Model
				$this->Setup_model->adminuser_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}


/*=== End Admin User ===*/

/*---- Media ----*/
public function medialist(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'Media',
			'description' => '',
			'keywords' => '',
			'heading' => 'Media',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treatcatlist"] = $this->Setup_model->get_media();
		$this->load->view('media/list', $data);
}
function addmedia(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Add Media',
			'description' => '',
			'keywords' => '',
			'heading' => 'Media',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_media_data';		
         $this->load->view('media/add', $data);
     }

 public function new_media_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'media_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$id = $this->Setup_model->media_insert($data);
				echo $errors_array.'Added Successfully';		
		}
	}

function editmedia($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_media_data/'.$id;
		$data["info"] = $this->Setup_model->get_mediaid($id);
		
         $this->load->view('media/edit', $data);
     }

 public function edit_media_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'media_name'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
				);
				//Transfering data to Model
				$this->Setup_model->media_update($data, $id);				
				echo $errors_array.'Update Successfully';
		}
	}

/*---- End Media ----*/

/*---- Job Function ----*/
public function jobfunction(){
	$session_data = $this->session->userdata('tms_ssndata');			
		$metadata = array(
			'title' => 'Job Function',
			'description' => '',
			'keywords' => '',
			'heading' => 'Job Function',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["treatcatlist"] = $this->Setup_model->get_jobfunction();
		$this->load->view('jobfunction/list', $data);
}
function addjobfunction(){
         $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Add Job Function',
			'description' => '',
			'keywords' => '',
			'heading' => 'Job Function',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/new_jobfunction_data';		
         $this->load->view('jobfunction/add', $data);
     }

 public function new_jobfunction_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'jf_title'=>$this->input->post('name'),
					'status'=>$this->input->post('status'),
					'added_by'=>$session_data['id'],
				);
				//Transfering data to Model
				$id = $this->Setup_model->jobfunction_insert($data);
				echo $errors_array.'Added Successfully';		
		}
	}

function editjobfunction($id){
        $session_data = $this->session->userdata('tms_ssndata');	
        $metadata = array(
			'title' => 'Job Function',
			'description' => '',
			'keywords' => '',
			'heading' => 'Job function',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			/*'center_id' => $session_data['center_id'],*/
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'setup/edit_jobfunction_data/'.$id;
		$data["info"] = $this->Setup_model->get_jobfunctionid($id);
		
         $this->load->view('jobfunction/edit', $data);
     }

 public function edit_jobfunction_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('tms_ssndata');
		//This method will have the credentials validation
		$validation_rules = array(
	               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),               	
	        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{
			//Setting values for tabel columns
			$data = array(
				'jf_title'=>$this->input->post('name'),
				'status'=>$this->input->post('status'),
			);
			//Transfering data to Model
			$this->Setup_model->jobfunction_update($data, $id);				
			echo $errors_array.'Update Successfully';
		}
	}

/*---- End Job Function ----*/

	function is_ajax(){
		if (!$this->input->is_ajax_request()) {
            if($this->session->userdata('tms_ssndata')){			
				redirect('admin', 'refresh');						
			}else{
				redirect('admin/login', 'refresh');
			}
		}
	}
	

	
} // End Class

?>