<!doctype html>
<html lang="en" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta content="Klinik Dr Inder" name="description">
		<meta content="Klinik Dr Inder" name="author">
		<meta name="keywords" content="Klinik Dr Inder"/>

		<!-- Favicon -->
		<link rel="icon" href="<?php echo base_url();?>assets/images/cdb-fav.ico" type="image/x-icon"/>
		<link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url();?>assets/images/cdb-fav.ico" />

		<!-- Title -->
		<title><?php echo $metadata['title'];?> – Klinik Dr Inder</title>

		<!--Bootstrap.min css-->
		<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/bootstrap/css/bootstrap.min.css">

		<!-- Dashboard css -->
		<link href="<?php echo base_url();?>assets/css/style.css" rel="stylesheet" />

		<!-- Custom scroll bar css-->
		<link href="<?php echo base_url();?>assets/plugins/scroll-bar/jquery.mCustomScrollbar.css" rel="stylesheet" />

		<!-- Sidemenu css -->
		<link href="<?php echo base_url();?>assets/plugins/toggle-sidebar/sidemenu.css" rel="stylesheet" />

		<!--Daterangepicker css-->
		<link href="<?php echo base_url();?>assets/plugins/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet" />

		<!-- Sidebar Accordions css -->
		<link href="<?php echo base_url();?>assets/plugins/accordion1/css/easy-responsive-tabs.css" rel="stylesheet">

		<!-- Rightsidebar css -->
		<link href="<?php echo base_url();?>assets/plugins/sidebar/sidebar.css" rel="stylesheet">

		<!---Font icons css-->
		<link href="<?php echo base_url();?>assets/plugins/iconfonts/plugin.css" rel="stylesheet" />
		<link href="<?php echo base_url();?>assets/plugins/iconfonts/icons.css" rel="stylesheet" />
		<link  href="<?php echo base_url();?>assets/fonts/fonts/font-awesome.min.css" rel="stylesheet">

		<!-- Data table css -->
		<link href="<?php echo base_url();?>assets/plugins/datatable/dataTables.bootstrap4.min.css" rel="stylesheet" />
		<link href="<?php echo base_url();?>assets/plugins/datatable/responsivebootstrap4.min.css" rel="stylesheet" />

		<!--Select2 css -->
		<link href="<?php echo base_url();?>assets/plugins/select2/select2.min.css" rel="stylesheet" />

		<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js"></script> 

	</head>

	<body class="app sidebar-mini rtl">

		<!--Global-Loader-->
		<div id="global-loader">
			<img src="<?php echo base_url();?>assets/images/icons/loader.svg" alt="loader">
		</div>

		<div class="page">
			<div class="page-main">
				<!--app-header-->
				<?php $this->load->view('includes/header');?>
				<!--app-header end-->
				

                <!-- app-content-->
				<div class="app-content  my-3 my-md-5 toggle-content">
					<div class="side-app">

						<!-- page-header -->
						<div class="page-header">
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="#">Report</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo $metadata['heading'];?> List</li>
							</ol><!-- End breadcrumb -->
							<div class="ml-auto">
								<a class="btn btn-success" href="<?php echo base_url('reports/quotationfilter');?>" ><i class="fe fe-filter mr-1 mt-1"></i><?php echo $metadata['heading'];?></a>
							</div>
						</div>
						<!-- End page-header -->

						<!-- row -->
						<div class="row">
							<div class="col-md-12">
								
								<div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title"><?php echo $metadata['heading'];?> Filter</h3>										
									</div>
									<div class="card-body">
										<form action="<?php echo base_url('reports/quotationfilter'); ?>" method="post" id="qfilter" name="qfilter">
											
										<div class="row">											
											<div class="col-3">
												<div class="form-group">
													<label class="form-label" for="name">Staff</label>
													<select name="staff_id" id="staff_id" class="form-control select2-show-search">
														<option value="">All</option>
														<?php foreach($getstaff as $stlist){?>
														<option value="<?php echo $stlist->staff_id;?>"><?php echo $stlist->staff_name;?></option>
														<?php }?>
													</select>
												</div>
											</div>
											<div class="col-3">	
												<div class="form-group">	
													<label>Year:</label>
													<select name="year" id="year" class="form-control select2-show-search">
													  <option value="">All</option>
													  <?php for($i=2018;$i<=date('Y');$i++){?>
														<option value="<?= $i?>"><?= $i?></option>
														<?php }?>
													</select>
												</div> 
											</div>
											<div class="col-3">	
												<div class="form-group">
													<label>Month:</label>
													<select name="month" id="month" class="form-control select2-show-search">
														<option value="">All</option>
														<option value="01">January</option>
														<option value="02">February</option>
														<option value="03">March</option>
														<option value="04">April</option>
														<option value="05">May</option>
														<option value="06">June</option>
														<option value="07">July</option>
														<option value="08">August</option>
														<option value="09">September</option>
														<option value="10">October</option>
														<option value="11">November</option>
														<option value="12">December</option>
													</select>
												</div> 
											</div>
											<div class="col-3">		
												<div class="form-group ">
													<label class="form-label">Status</label>
													<select name="status" id="status" class="form-control">
														<option value="">All</option>
														<option value="0">Deal Open</option>
														<option value="1">Deal Closs</option>
													</select>
													<div class="form-error" id="error-status"></div>
												</div>
											</div>											
											<div class="col-lg-12">
												<input type="submit" class="btn btn-primary float-right" value="Submit" id="submitbtn1" name="submitbtn1">
												<a href="<?php echo base_url('reports/quotationlist');?>" id="reset" class="btn btn-danger float-right">Reset</a>
											</div>											
										</div>
										</form>
									</div>
								</div>
							</div>
						</div>						
						<!--row closed-->

						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title"><?php echo $metadata['heading'];?> List</div>
								</div>
								<div class="card-body">
                                	<div class="table-responsive" id="hba1ctable">
										<table id="example" class="table table-striped table-bordered w-100">
											<thead class="bg-blue text-white">
												<tr>
													<th>Date</th>
													<th>Staff Name</th>
													<th>Patient Name</th>
													<th>Phone</th>
													<th>Email</th>
													<th>Description</th>
													<th>Status</th>
													<!-- <th>Action</th> -->
												</tr>
											</thead>
											<tbody>
												<?php foreach($getquotation as $list){?>
												<tr>
													<td><?php echo $list->qt_date;?></td>
													<td><?php echo $list->staff_name;?></td>
													<td><?php echo $list->customer_name;?></td>
													<td><?php echo $list->customer_phone;?></td>
													<td><?php echo $list->customer_email;?></td>
													<td><?php echo $list->description;?></td>
													<td><?php if($list->deal_status==1){echo 'Closs at '.$list->closs_datetime; }else{echo 'Pending';} ?></td>
													<!-- <td>
														<?php if($list->deal_status==0){?>
														<a href="javascript:void(0)" onclick="deal_record('<?php echo $list->qt_id; ?>')" class="btn btn-app btn-primary btn-sm"><i class="fa fa-list-alt"></i> Closs Deal</a>
														<?php }else{
															echo 'Closs on '.$list->closs_datetime;
														}?>
													</td> -->
												</tr>
												<?php }?>
												
												
												
											</tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						<!-- row end -->
						
						
					</div>
					<!-- Right-sidebar-->
					<!-- End Rightsidebar-->

					<!--footer-->
					<?php $this->load->view('includes/footer');?>
					<!-- End Footer-->

				</div>
				<!-- End app-content-->
			</div>
		</div>
		<!-- End Page -->

		<!-- Back to top -->
		<a href="#top" id="back-to-top"><i class="fa fa-angle-up"></i></a>

		<script type="text/javascript">
			$(document).ready(function(){
			    $('#example').DataTable({
			        order: [[0, 'desc']],
			    });
			});
			 
		</script>

		<!-- Jquery js-->
		<script src="<?php echo base_url();?>assets/js/vendors/jquery-3.2.1.min.js"></script>

		<!--Bootstrap.min js-->
		<script src="<?php echo base_url();?>assets/plugins/bootstrap/popper.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/bootstrap/js/bootstrap.min.js"></script>

		<!--Jquery Sparkline js-->
		<script src="<?php echo base_url();?>assets/js/vendors/jquery.sparkline.min.js"></script>

		<!-- Chart Circle js-->
		<script src="<?php echo base_url();?>assets/js/vendors/circle-progress.min.js"></script>

		<!-- Star Rating js-->
		<script src="<?php echo base_url();?>assets/plugins/rating/jquery.rating-stars.js"></script>

		<!--Moment js-->
		<script src="<?php echo base_url();?>assets/plugins/moment/moment.min.js"></script>

		<!-- Daterangepicker js-->
		<script src="<?php echo base_url();?>assets/plugins/bootstrap-daterangepicker/daterangepicker.js"></script>

		<!--Side-menu js-->
		<script src="<?php echo base_url();?>assets/plugins/toggle-sidebar/sidemenu.js"></script>

		<!-- Sidebar Accordions js -->
		<script src="<?php echo base_url();?>assets/plugins/accordion1/js/easyResponsiveTabs.js"></script>

		<!--Time Counter js-->
		<script src="<?php echo base_url();?>assets/plugins/counters/jquery.missofis-countdown.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/counters/counter.js"></script>

		<!-- Custom scroll bar js-->
		<script src="<?php echo base_url();?>assets/plugins/scroll-bar/jquery.mCustomScrollbar.concat.min.js"></script>

		<!-- Rightsidebar js -->
		<script src="<?php echo base_url();?>assets/plugins/sidebar/sidebar.js"></script>

		<!-- Data tables js-->
		<script src="<?php echo base_url();?>assets/plugins/datatable/jquery.dataTables.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/dataTables.bootstrap4.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/datatable.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/datatable-2.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/dataTables.responsive.min.js"></script>

		<!-- Datepicker js -->
		<script src="<?php echo base_url();?>assets/plugins/date-picker/spectrum.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/date-picker/jquery-ui.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/input-mask/jquery.maskedinput.js"></script>

		<!--Select2 js -->
		<script src="<?php echo base_url();?>assets/plugins/select2/select2.full.min.js"></script>
		<script src="<?php echo base_url();?>assets/js/select2.js"></script>

		<!-- Custom js-->
		<script src="<?php echo base_url();?>assets/js/custom.js"></script>

	</body>
</html>