<?php
class Reports_m extends CI_Model{
		
	


	public function get_anmtList() {
        $this -> db -> select('t1.*, t2.slot_name, t3.category_name');
		$this -> db -> from(DB_PREFIX.'appointmen t1');
		$this -> db -> join(DB_PREFIX.'timeslot t2', 't2.slot_id = t1.time_slot', 'left');
		$this -> db -> join(DB_PREFIX.'treatment_category t3', 't3.category_id = t1.category', 'left');
		$this -> db -> where('DATE(t1.appointment_date)', date('Y-m-d'));
		$this -> db -> order_by('cast(t1.start_time as decimal(10,2)) ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

   public function get_todayschedule(){		
		$this->db->select('t1.*,t2.staff_name, t3.room_name, t4.slot_name, t5.patient_name, t5.note');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'timeslot t4', 't4.slot_id = t1.treatment_time', 'left');
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		$this->db->where('t1.treatment_date', date('Y-m-d')); 
		$this->db->order_by('cast(t1.treatment_start as decimal(10,2)) ASC');
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_staffid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'staff');
		$this->db->where('staff_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function

    public function get_apnttreatmnt($aptid){		
		$this->db->select('t1.*,t2.treatment_name');
		$this->db->from(DB_PREFIX.'apt_treatment t1');
		$this->db->join(DB_PREFIX.'treatment_type t2', 't2.treatment_id = t1.apt_treatment_id', 'left'); 
		$this->db->where('t1.appointment_id', $aptid); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function view_sheduledata($cid) { 
        $this->db->select('t1.*,t2.staff_name, t3.room_name, t4.slot_name, t5.patient_name, t5.phone, t5.note');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'timeslot t4', 't4.slot_id = t1.treatment_time', 'left');
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		$this->db->where('t1.appointment_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

    public function get_timesheet() {
        $this->db->select('t1.*, t2.jf_title, t3.slot_name, t4.status_name, t5.staff_name');
		$this->db->from(DB_PREFIX.'timesheet t1');
		$this->db->join(DB_PREFIX.'jobfunction t2','t2.jf_id = t1.jobfunction_id', 'left');
		$this->db->join(DB_PREFIX.'timeslot t3','t3.slot_id = t1.timeslot', 'left');
		$this->db->join(DB_PREFIX.'taskstatus t4','t4.status_id = t1.status', 'left');
		$this->db->join(DB_PREFIX.'staff t5','t5.staff_id=t1.staff_id', 'left');
		/*$this->db->where('t1.staff_id', $sid);*/
		$this->db->where('DATE(t1.added_datetime)', date('Y-m-d'));
		$this->db->order_by('t3.slot_id', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

    public function get_timesheetdts($sid) {
        $this->db->select('t1.*, t2.jf_title, t3.slot_name, t4.status_name');
		$this->db->from(DB_PREFIX.'timesheet_history t1');
		$this->db->join(DB_PREFIX.'jobfunction t2','t2.jf_id = t1.jobfunction_id', 'left');
		$this->db->join(DB_PREFIX.'timeslot t3','t3.slot_id = t1.timeslot', 'left');
		$this->db->join(DB_PREFIX.'taskstatus t4','t4.status_id = t1.status', 'left');
		$this->db->where('t1.timesheet_id', $sid);
		$this->db->order_by('t3.slot_id', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

	public function get_timesheetbydate($td,$stfid) {
        $this->db->select('t1.*, t2.jf_title, t3.slot_name, t4.status_name, t5.staff_name');
		$this->db->from(DB_PREFIX.'timesheet t1');
		$this->db->join(DB_PREFIX.'jobfunction t2','t2.jf_id = t1.jobfunction_id', 'left');
		$this->db->join(DB_PREFIX.'timeslot t3','t3.slot_id = t1.timeslot', 'left');
		$this->db->join(DB_PREFIX.'taskstatus t4','t4.status_id = t1.status', 'left');
		$this->db->join(DB_PREFIX.'staff t5','t5.staff_id=t1.staff_id', 'left');
		if(!empty($stfid)){
			$this->db->where('t1.staff_id', $stfid);
		}		
		$this->db->where('DATE(t1.added_datetime)', $td);
		$this->db->order_by('t3.slot_id', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

    public function get_staff(){
    	$this->db->select('*');
		$this->db->from(DB_PREFIX.'staff');
		$this->db->order_by('staff_name','ASC');
		$query = $this->db->get();
		return $query->result();
    }

    public function get_todaymkt($type) {
        $this->db->select('t1.*, t2.media_name, t3.staff_name');
		$this->db->from(DB_PREFIX.'marketing t1');
		$this->db->join(DB_PREFIX.'media t2','t2.media_id = t1.media_id', 'left');
		$this->db->join(DB_PREFIX.'staff t3','t3.staff_id = t1.staff_id', 'left');
		/*$this->db->where('t1.staff_id', $sid);*/
		$this->db->where('t1.mkt_type', $type);
		$this->db->where('DATE(t1.mkt_date)', date('Y-m-d'));
		$this->db->order_by('t3.staff_name', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

    public function get_mktfilter($mdate,$sid,$type) {
        $this->db->select('t1.*, t2.media_name, t3.staff_name');
		$this->db->from(DB_PREFIX.'marketing t1');
		$this->db->join(DB_PREFIX.'media t2','t2.media_id = t1.media_id', 'left');
		$this->db->join(DB_PREFIX.'staff t3','t3.staff_id = t1.staff_id', 'left');
		
		$this->db->where('t1.mkt_type', $type);
		$this->db->where('DATE(t1.mkt_date)', $mdate);
		if(!empty($sid)){
			$this->db->where('t1.staff_id', $sid);
		}
		$this->db->order_by('t3.staff_name', 'ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function 

    public function get_postinglist($sid) {
        $this->db->select('t1.*, t2.media_name, t3.staff_name');
		$this->db->from(DB_PREFIX.'posting t1');
		$this->db->join(DB_PREFIX.'media t2','t2.media_id = t1.media_id', 'left');
		$this->db->join(DB_PREFIX.'staff t3','t3.staff_id = t1.staff_id', 'left');
		/*$this->db->where('t1.staff_id', $sid);*/
		$this->db->order_by('t1.post_date', 'DESC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

    public function get_quotation() {
        $this->db->select('t1.*, t2.customer_name, t2.customer_phone, t2.customer_email,t3.staff_name');
		$this->db->from(DB_PREFIX.'quotation t1');
		$this->db->join(DB_PREFIX.'customer t2','t2.customer_id = t1.customer_id', 'left');
		$this->db->join(DB_PREFIX.'staff t3','t3.staff_id = t1.staff_id', 'left');
		/*$this->db->where('t1.staff_id', $sid);*/
		$this->db->order_by('t1.qt_date', 'DESC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

public function get_quotationfilter($staff,$year,$month,$status) {
        $this->db->select('t1.*, t2.customer_name, t2.customer_phone, t2.customer_email,t3.staff_name');
		$this->db->from(DB_PREFIX.'quotation t1');
		$this->db->join(DB_PREFIX.'customer t2','t2.customer_id = t1.customer_id', 'left');
		$this->db->join(DB_PREFIX.'staff t3','t3.staff_id = t1.staff_id', 'left');
		if(!empty($staff)){
			$this->db->where('t1.staff_id', $staff);
		}
		if(!empty($status)){
			$this->db->where('t1.deal_status', $status);
		}
		if(!empty($year)){
			$this->db->where('YEAR(t1.qt_date)',$year);
		}
		if(!empty($month)){
			$this->db->where('MONTH(t1.qt_date)',$month);
		}
		$this->db->order_by('t1.qt_date', 'DESC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

public function get_staffdepartment(){
    	$this->db->select('*');
		$this->db->from(DB_PREFIX.'staff_category');
		$this->db->order_by('category_name','ASC');
		$query = $this->db->get();
		return $query->result();
    }
public function get_staffbydept($dept){
    	$this->db->select('*');
		$this->db->from(DB_PREFIX.'staff');
		if(!empty($dept)){
			$this->db->where('staff_category', $dept);
		}		
		$this->db->order_by('staff_name','ASC');
		$query = $this->db->get();
		return $query->result();
    }

public function get_intime($id,$date){
	$this->db->select('Date_Time, Staff_ip');
	$this->db->from(DB_PREFIX.'staff_logininfo');
	$this->db->where('staff_id', $id);
	$this->db->where('DATE(Date_Time)', $date);
	$this->db->where('Login_Note', 'In');
	$this->db->order_by('id', 'ASC');
	$query = $this->db->get();
	return $query->first_row();
}

public function get_outtime($id,$date){
	$this->db->select('Date_Time, Staff_ip');
	$this->db->from(DB_PREFIX.'staff_logininfo');
	$this->db->where('staff_id', $id);
	$this->db->where('DATE(Date_Time)', $date);
	$this->db->where('Login_Note', 'Out');
	$this->db->order_by('id', 'DESC');
	$query = $this->db->get();
	return $query->first_row();
}


											
	
}//end of Class 
?>