<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends CI_Controller{
	
	function __construct(){
		parent::__construct();
		
		$this->load->model('reports_m');
		$this->load->library('forminput');	
		$this->load->library('form_validation');
		$this->load->library('form_engine');
		$this->load->library('Querylib');
		$this->load->library('datatables');
		$this->load->library('email');
		//$this->load->module("users");
		
		//if(!$this->users->_is_admin()){
			//show_404();
		//}
		
	}
	
	function timesheet(){
		
		if($this->session->userdata('tms_ssndata')){
    	
			$session_data = $this->session->userdata('tms_ssndata');			
			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['todaytask'] = $this->reports_m->get_timesheet();
			$this->load->view('timesheet/timesheet_list',$data);
						
    	}else{
      		//If no session, redirect to login page
      		redirect('admin/login', 'refresh');
		}
		
	} 

	public function timesheetbydate(){
		$ptdata = $this->input->post('ptdata');
		$stfid = $this->input->post('stfid');		
		$data["todaytask"] = $this->reports_m->get_timesheetbydate($ptdata,$stfid);
		$data["slctdt"] = $ptdata;
		$this->load->view('timesheet/databydate',$data);	
	}
	
	public function timesheetbydate_exl(){
		$ptdata = $this->input->post('from_date');
		$stfid = $this->input->post('staff_id');
		
		$data["todaytask"] = $this->reports_m->get_timesheetbydate($ptdata,$stfid);
		$data["slctdt"] = $ptdata;
		$this->load->view('timesheet/timesheet_exl',$data);	
	}

	function enquirylist(){		
		if($this->session->userdata('tms_ssndata')){    	
			$session_data = $this->session->userdata('tms_ssndata');			
			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$type = 'enquiry';
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['gettodaymkt'] = $this->reports_m->get_todaymkt($type);
			$this->load->view('enquiry/enquiry_list',$data);
						
    	}else{
      		//If no session, redirect to login page
      		redirect('admin/login', 'refresh');
		}		
	}

	function followuplist(){		
		if($this->session->userdata('tms_ssndata')){    	
			$session_data = $this->session->userdata('tms_ssndata');			
			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$type = 'followup';
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['gettodaymkt'] = $this->reports_m->get_todaymkt($type);
			$this->load->view('followup/followup_list',$data);
						
    	}else{
      		//If no session, redirect to login page
      		redirect('admin/login', 'refresh');
		}		
	} 

	public function equiryfilter($type){
		$ptdata = $this->input->post('ptdata');
		$stfid = $this->input->post('stfid');		
		$data["mktfilter"] = $this->reports_m->get_mktfilter($ptdata,$stfid,$type);
		$data["slctdt"] = $ptdata;
		$this->load->view('enquiry/databydate',$data);	
	}

	function postinglist(){		
		if($this->session->userdata('tms_ssndata')){    	
			$session_data = $this->session->userdata('tms_ssndata');			
			$metadata = array(
				'title' => 'Posting',
				'heading' => 'Posting',
				'description' => 'Posting',
				'keywords' => 'Posting',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'imageuploadurl' => base_url('a_imageupload'),				
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$type = 'followup';
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['getposting'] = $this->reports_m->get_postinglist($type);
			$this->load->view('postinglist',$data);						
    	}else{
      		//If no session, redirect to login page
      		redirect('admin/login', 'refresh');
		}		
	}

	public function quotationlist(){
		if ($this->session->userdata('tms_ssndata')) {
			$session_data = $this->session->userdata('tms_ssndata');
			$metadata = array(
				'title' => 'Quatation',
				'heading' => 'Quatation',
				'description' => 'Quatation',
				'keywords' => 'Quatation',
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',	
			);
			$data['metadata'] = $metadata;
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['getquotation'] = $this->reports_m->get_quotation();
			$this->load->view('quotation/quotationlist', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	} 
	
	public function quotationfilter(){
		if ($this->session->userdata('tms_ssndata')) {
			$session_data = $this->session->userdata('tms_ssndata');
			$metadata = array(
				'title' => 'Quatation Filter',
				'heading' => 'Quatation Filter',
				'description' => 'Quatation Filter',
				'keywords' => 'Quatation',
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',
				'syear' => $this->input->post('year'),
				'smonth' => $this->input->post('month'),
				'sstaff' => $this->input->post('staff_id'),
				'sstatus' => $this->input->post('status'),
			);
			$data['metadata'] = $metadata;
			$year = $this->input->post('year');
			$month = $this->input->post('month');
			$staff = $this->input->post('staff_id');
			$status = $this->input->post('status');
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['getquotation'] = $this->reports_m->get_quotationfilter($staff,$year,$month,$status);
			$this->load->view('quotation/quotation', $data);
			
		}else{
			redirect('staff/login', 'refresh');
		}
	} 

	public function inoutlist(){
		if($this->session->userdata('tms_ssndata')){
			$session_data = $this->session->userdata('tms_ssndata');
			$metadata = array(
				'title' => 'In Out Time',
				'heading' => 'In Out Time',
				'description' => 'Quatation Filter',
				'keywords' => 'Quatation',
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',
			);
			$data['metadata'] = $metadata;			
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['getdepartment'] = $this->reports_m->get_staffdepartment();
			$this->load->view('inout/inout', $data);
		}else{
			redirect('staff/login', 'refresh');
		}
	}
	
	public function inoutfilter(){
		if($this->session->userdata('tms_ssndata')){
			$session_data = $this->session->userdata('tms_ssndata');
			$metadata = array(
				'title' => 'In Out Time',
				'heading' => 'In Out Time',
				'description' => 'Quatation Filter',
				'keywords' => 'Quatation',
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',
				'syear' => $this->input->post('year'),
				'smonth' => $this->input->post('month'),
				'sstaff' => $this->input->post('staff_id'),
				'sdate' => $this->input->post('from_date'),
			);
			$data['metadata'] = $metadata;
			$year = $this->input->post('year');
			$month = $this->input->post('month');
			$staff = $this->input->post('staff_id');
			$date = $this->input->post('from_date');
			$dept = $this->input->post('dept');
			$data['getstaff'] = $this->reports_m->get_staff();
			$data['getdepartment'] = $this->reports_m->get_staffdepartment();
			$data['getstaffbydept'] = $this->reports_m->get_staffbydept($dept);
			$this->load->view('inout/inoutfilter', $data);
		}else{
			redirect('staff/login', 'refresh');
		}
	}
	


	
	  
	 
		
}

?>