<!doctype html>
<html lang="en" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta content="Klinik Dr Inder" name="description">
		<meta content="Klinik Dr Inder" name="author">
		<meta name="keywords" content="Changing Diabetes Barometer (CDB)"/>

		<!-- Favicon -->
		<link rel="icon" href="<?php echo base_url();?>assets/images/cdb-fav.ico" type="image/x-icon"/>
		<link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url();?>assets/images/cdb-fav.ico" />

		<!-- Title -->
		<title>Appointment List – Klinik Dr Inder</title>

		<!--Bootstrap.min css-->
		<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/bootstrap/css/bootstrap.min.css">

		<!-- Dashboard css -->
		<link href="<?php echo base_url();?>assets/css/style.css" rel="stylesheet" />

		<!-- Custom scroll bar css-->
		<link href="<?php echo base_url();?>assets/plugins/scroll-bar/jquery.mCustomScrollbar.css" rel="stylesheet" />

		<!-- Horizontal-menu css -->
		<link href="<?php echo base_url();?>assets/plugins/horizontal-menu/dropdown-effects/fade-down.css" rel="stylesheet">
		<link href="<?php echo base_url();?>assets/plugins/horizontal-menu/horizontalmenu.css" rel="stylesheet">

		<!--Daterangepicker css-->
		<link href="<?php echo base_url();?>assets/plugins/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet" />

		<!-- Sidebar Accordions css -->
		<link href="<?php echo base_url();?>assets/plugins/accordion1/css/easy-responsive-tabs.css" rel="stylesheet">

		<!-- Rightsidebar css -->
		<link href="<?php echo base_url();?>assets/plugins/sidebar/sidebar.css" rel="stylesheet">

		<!---Font icons css-->
		<link href="<?php echo base_url();?>assets/plugins/iconfonts/plugin.css" rel="stylesheet" />
		<link href="<?php echo base_url();?>assets/plugins/iconfonts/icons.css" rel="stylesheet" />
		<link  href="<?php echo base_url();?>assets/fonts/fonts/font-awesome.min.css" rel="stylesheet">

		<!-- Data table css -->
		<link href="<?php echo base_url();?>assets/plugins/datatable/dataTables.bootstrap4.min.css" rel="stylesheet" />
		<link href="<?php echo base_url();?>assets/plugins/datatable/responsivebootstrap4.min.css" rel="stylesheet" />

		<!--Select2 css -->
		<link href="<?php echo base_url();?>assets/plugins/select2/select2.min.css" rel="stylesheet" />

		<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js"></script> 

	</head>

	<body class="app sidebar-mini rtl">

		<!--Global-Loader-->
		<div id="global-loader">
			<img src="<?php echo base_url();?>assets/images/icons/loader.svg" alt="loader">
		</div>

		<div class="page">
			<div class="page-main">
				<!--app-header-->
				<?php $this->load->view('includes/headermenu');?>
				<!--app-header end-->
				

                <!-- app-content-->
				<div class="container content-area">
					<div class="side-app">

						<!-- page-header -->
						<!-- page-header -->
						<div class="page-header">
							
                            
						</div>
						<!-- End page-header -->
						<!-- End page-header -->

						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">Appointment List</div>
									<div class="card-options">
										<a href="<?php echo base_url('appointment/appointmentbydate');?>" class="btn btn-sm btn-info"><i class="fa fa-plus"></i> Date wise Appointment</a>		
									</div>
								</div>
								<div class="card-body">
                                	<div class="table-responsive" id="hba1ctable">
										<table id="example" class="table table-striped table-bordered w-100">
											<thead class="bg-blue text-white">
												<tr>
													<th>Appointment Date</th>
													<th>Time Slot</th>
													<th>Patients Name</th>													
													<th>Phone</th>
													<th>Treatment</th>
													<!-- <th>Note</th> -->
													<th>Status</th>
													<th>Action</th>
												</tr>
											</thead>
											<tbody>
										  	<?php foreach($apnmentlist as $tdlist){?>
											<tr>
												<td><?php echo $tdlist->appointment_date;?></td>
												<td><?php echo $tdlist->slot_name;?></td>
												<td><?php echo $tdlist->patient_name;?></td>
												<td><?php echo $tdlist->phone;?></td>
												<td>
													<?php $getapttrtmnt = $this->registration_m->get_apnttreatmnt($tdlist->id);?>
													<?php $i = 1; foreach($getapttrtmnt as $atrmnt){
														echo $i.'.'.$atrmnt->treatment_name.', ';
														$i++;
													}?>
												</td>
												<!-- <td><?php echo $tdlist->note;?></td> -->
												<td><?php if ($tdlist->status == 0) {
													echo 'Pending';
												}elseif ($tdlist->status == 1) {?>													
													<a href="#" class="text-success" data-toggle="modal" data-target="#myModal" onclick="data_view('<?php echo $tdlist->id; ?>')" >Scheduled</a>
												<?php }elseif ($tdlist->status == 2) {
													echo '<span class="text-danger">Canceled</div>';
												} ?></td>
												<td>
													<a href="<?php echo base_url('appointment/editapt/').$tdlist->id;?>" class="btn btn-primary btn-sm" ><i class="fa fa-pencil" aria-hidden="true"></i>Edit</a>
													<?php if ($tdlist->status == 0) {?>
													<a href="<?php echo base_url('appointment/aptschedule/').$tdlist->id;?>" class="btn btn-info btn-sm" ><i class="fa fa-clock-o" aria-hidden="true"></i>Schedule</a>
													<?php } ?>
													<?php if ($tdlist->status == 2) {?>
													<a href="#" class="btn btn-success btn-sm" onclick="restor_record('<?php echo $tdlist->id; ?>')" ><i class="fa fa-window-restore" aria-hidden="true"></i>Restore</a>
													<?php }else{?>
														<a href="#" class="btn btn-danger btn-sm" onclick="cancel_record('<?php echo $tdlist->id; ?>')" ><i class="fa fa-ban" aria-hidden="true"></i>Cancel</a>
													<?php } ?>
													

												</td>
											</tr>
											<?php }?>	
										  </tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						<!-- row end -->
						
						
					</div>
					<!-- Right-sidebar-->
					<!-- End Rightsidebar-->

					<!--footer-->
					<?php $this->load->view('includes/footer');?>
					<!-- End Footer-->

				</div>
				<!-- End app-content-->
			</div>
		</div>
		<!-- End Page -->

		<!-- Back to top -->
		<a href="#top" id="back-to-top"><i class="fa fa-angle-up"></i></a>

        <!-- The Modal -->
<div class="modal fade" id="myModal">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Schedule Details</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body" id="qsndata">
        
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>



		<script type="text/javascript">
			$(document).ready(function(){
			    
			   datalist = $('#example').dataTable( {
				  "searching": true,
				  "order": [[ 0, "desc" ]],
				  /*"processing": true,*/
      			  /*"serverSide": true,*/
      			  "searching":true,
      			  "serverSide":false,
      			  "processing": true,
				} );

				$('button').click( function() {
			        var data = table.$('input, select').serialize();
			        alert(
			            "The following data would have been submitted to the server: \n\n"+
			            data.substr( 0, 120 )+'...'
			        );
			        return false;
			    } );
			});


			$(document).ready(function(){
			    $('#fromdate').datepicker({
		            changeMonth: true,
		            changeYear: true,
		            dateFormat: 'yy-mm-dd',
					onSelect: function(value, ui) {
		                
		                $('#year option:not(:selected)').attr('disabled', true);
		                $('#month option:not(:selected)').attr('disabled', true);
		            },
		        })
				$('#todate').datepicker({
		            changeMonth: true,
		            changeYear: true,
		            dateFormat: 'yy-mm-dd',
					onSelect: function(value, ui) {
		                
		                $('#year option:not(:selected)').attr('disabled', true);
		                $('#month option:not(:selected)').attr('disabled', true);
		            },
		        })
				$("#year").change(function(){
				  $('#todate').attr('readonly', 'readonly');
				  $('#fromdate').attr('readonly', 'readonly');
				 
				 $("#todate").css({"pointer-events": "none"});
				 $("#fromdate").css({"pointer-events": "none"});
				  
				});
				$("#month").change(function(){
				  $('#todate').attr('readonly', 'readonly');
				  $('#fromdate').attr('readonly', 'readonly');

				 $("#todate").css({"pointer-events": "none"});
				 $("#fromdate").css({"pointer-events": "none"});
				  
				});
			});

			function cancel_record(id){
	            if (confirm('Are you sure you want to cancel this?')) {
	                $.ajax({                      
	                     url:"<?php echo base_url(); ?>appointment/cancel_apt",  
	                     method:"POST",  
	                     data:{id:id},  
	                     success:function(data)  
	                     { 
	                          alert(data);  
	                          /*datalist.ajax.reload();*/  
	                          var jmpurl='<?php echo base_url('appointment/appointment_list');?>';
	                          window.location=jmpurl;
	                     }  
	                
	                });
	            }else{
	                return false;
	            }
	          }

	        function restor_record(id){ 
            
	            if (confirm('Are you sure you want to restore this?')) {
	                $.ajax({                      
	                     url:"<?php echo base_url(); ?>appointment/restor_apt",  
	                     method:"POST",  
	                     data:{id:id},  
	                     success:function(data)  
	                     { 
	                          alert(data);  
	                          /*datalist.ajax.reload();*/  
	                          var jmpurl='<?php echo base_url('appointment/appointment_list');?>';
	                          window.location=jmpurl;
	                     } 
	                });
	            }else{
	                return false;
	            }
	          }

	        function view_schedule(id){
	        	var loader='<div style="text-align: center;"><i class="fa fa-refresh fa-spin fa-4x fa-fw"></i></div>';
				 $('#qsndata').html(loader);
				    $.ajax({
				        url:"<?php echo base_url(); ?>appointment/schedule_dtl",  
				        method:"POST",  
				        data:{id:id},  
				        success:function(data)  
				            { 
				                $("#qsndata").html(data);
				            }  
				                
				    });
	        } 

	        function data_view(id){ 
			 var loader='<div style="text-align: center;"><i class="fa fa-refresh fa-spin fa-4x fa-fw"></i></div>';
			 $('#qsndata').html(loader);         
			            
			    $.ajax({
			        url:"<?php echo base_url(); ?>appointment/schedule_dtl",  
			        method:"POST",  
			        data:{id:id},  
			        success:function(data)  
			            { 
			                $("#qsndata").html(data);
			            }   
			    });     
			} 
			 
		</script>

		<!-- Jquery js-->
		<script src="<?php echo base_url();?>assets/js/vendors/jquery-3.2.1.min.js"></script>

		<!--Bootstrap.min js-->
		<script src="<?php echo base_url();?>assets/plugins/bootstrap/popper.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/bootstrap/js/bootstrap.min.js"></script>

		<!--Jquery Sparkline js-->
		<script src="<?php echo base_url();?>assets/js/vendors/jquery.sparkline.min.js"></script>

		<!-- Chart Circle js-->
		<script src="<?php echo base_url();?>assets/js/vendors/circle-progress.min.js"></script>

		<!-- Star Rating js-->
		<script src="<?php echo base_url();?>assets/plugins/rating/jquery.rating-stars.js"></script>

		<!--Moment js-->
		<script src="<?php echo base_url();?>assets/plugins/moment/moment.min.js"></script>

		<!-- Daterangepicker js-->
		<script src="<?php echo base_url();?>assets/plugins/bootstrap-daterangepicker/daterangepicker.js"></script>

		<!-- Horizontal-menu js -->
		<script src="<?php echo base_url();?>assets/plugins/horizontal-menu/horizontalmenu.js"></script>

		<!-- Sidebar Accordions js -->
		<script src="<?php echo base_url();?>assets/plugins/accordion1/js/easyResponsiveTabs.js"></script>

		<!--Time Counter js-->
		<script src="<?php echo base_url();?>assets/plugins/counters/jquery.missofis-countdown.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/counters/counter.js"></script>

		<!-- Custom scroll bar js-->
		<script src="<?php echo base_url();?>assets/plugins/scroll-bar/jquery.mCustomScrollbar.concat.min.js"></script>

		<!-- Rightsidebar js -->
		<script src="<?php echo base_url();?>assets/plugins/sidebar/sidebar.js"></script>

		<!-- Data tables js-->
		<script src="<?php echo base_url();?>assets/plugins/datatable/jquery.dataTables.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/dataTables.bootstrap4.min.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/datatable.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/datatable-2.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/datatable/dataTables.responsive.min.js"></script>

		<!-- Datepicker js -->
		<script src="<?php echo base_url();?>assets/plugins/date-picker/spectrum.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/date-picker/jquery-ui.js"></script>
		<script src="<?php echo base_url();?>assets/plugins/input-mask/jquery.maskedinput.js"></script>

		<!--Select2 js -->
		<script src="<?php echo base_url();?>assets/plugins/select2/select2.full.min.js"></script>
		<script src="<?php echo base_url();?>assets/js/select2.js"></script>

		<!-- Custom js-->
		<script src="<?php echo base_url();?>assets/js/custom.js"></script>

	</body>
</html>