<?php
class Registration_m extends CI_Model{
		
	public function regi_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'appointmen', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

   	public function get_anmtListall() {
        $this -> db -> select('t1.*, t2.slot_name, t3.category_name');
		$this -> db -> from(DB_PREFIX.'appointmen t1');
		/*$this -> db -> where('DATE(appointment_date)', date('Y-m-d'));*/
		$this -> db -> join(DB_PREFIX.'timeslot t2', 't2.slot_id = t1.time_slot', 'left');
		$this -> db -> join(DB_PREFIX.'treatment_category t3', 't3.category_id = t1.category', 'left');
		$this -> db -> order_by('id','DESC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

    public function get_treattype(){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'treatment_category');
    	$this->db->where('status',1);
    	$this->db->order_by('category_name','ASC');
    	$query = $this->db->get();
    	return $query->result();
    }

    public function get_time(){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'timeslot');
    	$this->db->where('status', 1);
    	$this->db->order_by('slot_id', 'ASC');
    	$query = $this->db->get();
    	return $query->result();
    }

	public function get_apttime(){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'apttime');
    	$this->db->where('status', 1);
    	$this->db->order_by('apttime_name', 'ASC');
    	$query = $this->db->get();
    	return $query->result();
    }

    public function get_endtime($starttime){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'apttime');
    	$this->db->where('apttime_name >', $starttime);
    	$this->db->order_by('apttime_name', 'ASC');
    	$query = $this->db->get();
    	$output = '<option value="">Select End Time</option>';
    	foreach($query->result() as $row){
    		$output .= '<option value="'.$row->apttime_name.'">'.$row->apttime_name.'</option>';
    	}
    	return $output;
    }

    public function get_endtimeforedit($starttime){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'apttime');
    	$this->db->where('apttime_name >', $starttime);
    	$this->db->order_by('apttime_name', 'ASC');
    	$query = $this->db->get();
    	return $query->result();
    }

  public function getnomachine($trtmnt){
  	$this->db->select('treatment_name, numberof_machine');
  	$this->db->from(DB_PREFIX.'treatment_type');
  	$this->db->where('treatment_id', $trtmnt);
  	$query = $this->db->get();
	return $query->first_row();
  }

public function getaptsdl($trtmnt, $aptdate, $st, $end){
  	$this->db->select('t1.aptt_id, t1.appointment_id,t2.start_time,t2.end_time');
  	$this->db->from(DB_PREFIX.'apt_treatment t1');
  	$this -> db -> join(DB_PREFIX.'appointmen t2', 't2.id = t1.appointment_id', 'left');
  	$this->db->where('t1.apt_treatment_id', $trtmnt);
  	$this->db->where('t2.appointment_date', $aptdate);
  	/*$this->db->where('t2.start_time >=', $st);
  	$this->db->where('t2.end_time >=', $end);*/
  	$query = $this->db->get();
	return $query->first_row();
  }

public function getaptsdl2($trtmnt, $aptdate, $st, $end){
  	$this->db->select('t1.aptt_id, t1.appointment_id,t2.start_time,t2.end_time FROM');
  	$this->db->from(DB_PREFIX.'apt_treatment t1');
  	$this->db->join(DB_PREFIX.'appointmen t2', 't2.id = t1.appointment_id', 'left');
  	$this->db->where('t1.apt_treatment_id', $trtmnt);
  	$this->db->where('t2.appointment_date', $aptdate);
  	$this->db->where('t2.start_time >=', $st);
  	$this->db->where('t2.start_time <', $end);
  	$this->db->or_where('t2.end_time >=', $end);
  	$this->db->where('t2.end_time <', $end);
  	$query = $this->db->get();
	/*return $query->result();*/
	return $query->num_rows();
  }

  public function checkavailble($trtmnt, $aptdate, $st, $end){
  	$query = $this->db->query("SELECT t1.aptt_id, t1.appointment_id, t1.apt_treatment_id, t2.start_time, t2.end_time FROM drindr_apt_treatment t1 
			LEFT JOIN drindr_appointmen t2 ON t2.id = t1.appointment_id WHERE t1.apt_treatment_id = '$trtmnt' AND t2.appointment_date = '$aptdate' 
			AND (
				      t2.start_time BETWEEN  '$st' AND '$end'
				      OR t2.end_time BETWEEN '$st' AND '$end'
				)
			");
  	return $query->num_rows();
  }





    public function get_appointmentdata($cid) { 
        $this -> db -> select('t1.*, t2.slot_name, t3.category_name');
		$this -> db -> from(DB_PREFIX.'appointmen t1');
		/*$this -> db -> where('DATE(appointment_date)', date('Y-m-d'));*/
		$this -> db -> join(DB_PREFIX.'timeslot t2', 't2.slot_id = t1.time_slot', 'left');
		$this -> db -> join(DB_PREFIX.'treatment_category t3', 't3.category_id = t1.category', 'left');
		$this->db->where('t1.id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

    public function get_subcat($id){
    	$this->db->select('*');
    	$this->db->from(DB_PREFIX.'treatment_type');
    	$this->db->where('treatment_category', $id);
    	$this->db->order_by('treatment_name', 'ASC');
    	$query = $this->db->get();
    	return $query->result();
    }

    public function treatment_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'apt_treatment', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

   	public function check_treatment($aptid, $tid){		
		$this->db->select('aptt_id');
		$this->db->from(DB_PREFIX.'apt_treatment');
		$this->db->where('apt_treatment_id', $tid);
		$this->db->where('appointment_id', $aptid); 
		$query = $this->db->get();				
		if ($query->num_rows() > 0) {
			$row = $query->row();
        	return $row->aptt_id;
		}
		return 0;	
	}// End function

	public function history_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'appointmen_history', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

	public function get_treamntdata($aptid){		
		$this->db->select('*');
		$this->db->from(DB_PREFIX.'apt_treatment');
		$this->db->where('appointment_id', $aptid); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function trmnt_history_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'apt_treatment_history', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function	

   	public function removetrmn($id){   		
		$this->db->trans_start();
		$this->db->where('appointment_id', $id);
		$this->db->delete(DB_PREFIX.'apt_treatment');	
		$this->db->trans_complete();
   	}

   	public function apt_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('id', $id);
		$this->db->update(DB_PREFIX.'appointmen', $data);				
		$this->db->trans_complete();					
   	} // End of function 

	public function get_doctor(){		
		$this->db->select('*');
		$this->db->from(DB_PREFIX.'staff');
		$this->db->where('staff_category', 2); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_nurse(){		
		$this->db->select('*');
		$this->db->from(DB_PREFIX.'staff');
		$this->db->where('staff_category', 1); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_apnttreatmnt($aptid){		
		$this->db->select('t1.*,t2.treatment_name');
		$this->db->from(DB_PREFIX.'apt_treatment t1');
		$this->db->join(DB_PREFIX.'treatment_type t2', 't2.treatment_id = t1.apt_treatment_id', 'left'); 
		$this->db->where('t1.appointment_id', $aptid); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_room(){		
		$this->db->select('*');
		$this->db->from(DB_PREFIX.'room');
		$this->db->order_by('room_name', 'ASC'); 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function schedule_insert($data) {        
		//Transfering data to Model
		$this->db->trans_start();
		$this->db->insert(DB_PREFIX.'schedule', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;			
   	} // End of function

   	public function get_schedule(){		
		$this->db->select('t1.*,t2.staff_name, t3.room_name, t4.slot_name, t5.patient_name');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'timeslot t4', 't4.slot_id = t1.treatment_time', 'left');
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		/*$this->db->where('t1.appointment_id', $aptid);*/ 
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_staffid($cid) { 
        $this -> db -> select('*');
		$this -> db -> from(DB_PREFIX.'staff');
		$this->db->where('staff_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

    public function get_sheduledata($cid) { 
        $this->db->select('t1.*,t2.staff_name, t3.room_name, t4.slot_name, t5.patient_name, t5.phone, t5.note');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'timeslot t4', 't4.slot_id = t1.treatment_time', 'left');
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		$this->db->where('t1.schedule_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

    public function schedule_update($data, $id) {
        //Transfering data to Model
		$this->db->trans_start();
		$this->db->where('schedule_id', $id);
		$this->db->update(DB_PREFIX.'schedule', $data);				
		$this->db->trans_complete();					
   	} // End of function 

   	public function view_sheduledata($cid) { 
        $this->db->select('t1.*,t2.staff_name, t3.room_name, t4.slot_name, t5.patient_name, t5.phone, t5.note');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'timeslot t4', 't4.slot_id = t1.treatment_time', 'left');
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		$this->db->where('t1.appointment_id', $cid);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

   public function customer_data($cid,$mbrnm) { 
        $this->db->select('*');
		$this->db->from(DB_PREFIX.'patient');		
		$this->db->where('pttelcel', $cid);
		$this->db->where('ptname', $mbrnm);
		$query = $this->db->get();
		return $query->first_row();
    } // End of function 

    public function get_schedulebydate($sdt){		
		$this->db->select('t1.*,t2.staff_name, t3.room_name, t5.patient_name, t5.note');
		$this->db->from(DB_PREFIX.'schedule t1');
		$this->db->join(DB_PREFIX.'staff t2', 't2.staff_id = t1.doctor_id', 'left');
		$this->db->join(DB_PREFIX.'room t3', 't3.room_id = t1.room_id', 'left'); 
		$this->db->join(DB_PREFIX.'appointmen t5', 't5.id = t1.appointment_id', 'left');
		$this->db->where('t1.treatment_date', $sdt);
		$this->db->order_by('cast(t1.treatment_start as decimal(10,2)) ASC');
		$query = $this->db->get();
    	return $query->result();	
	}// End function

	public function get_anmtListToday($td) {
        $this -> db -> select('t1.*, t2.slot_name, t3.category_name');
		$this -> db -> from(DB_PREFIX.'appointmen t1');
		$this -> db -> join(DB_PREFIX.'timeslot t2', 't2.slot_id = t1.time_slot', 'left');
		$this -> db -> join(DB_PREFIX.'treatment_category t3', 't3.category_id = t1.category', 'left');
		$this -> db -> where('DATE(t1.appointment_date)', $td);
		$this -> db -> order_by('cast(t1.start_time as decimal(10,2)) ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

    public function get_aptHistory($td) {
        $this -> db -> select('t1.*, t3.category_name');
		$this -> db -> from(DB_PREFIX.'appointmen_history t1');
		$this -> db -> join(DB_PREFIX.'treatment_category t3', 't3.category_id = t1.category', 'left');
		$this -> db -> where('t1.apt_id', $td);
		$this -> db -> order_by('cast(t1.start_time as decimal(10,2)) ASC');
		$query = $this->db->get();
		return $query->result();
    } // End of function

    public function check_aptHistory($td) {
        $this -> db -> select('id');
		$this -> db -> from(DB_PREFIX.'appointmen_history');		
		$this -> db -> where('apt_id', $td);		
		$query = $this->db->get();
		return $query->result();
    } // End of function


	
}//end of Class 
?>