<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Appointment extends CI_Controller{
	
	function __construct(){
		parent::__construct();
		if($this->session->userdata('sht_ssndata')){
			$this->load->model('registration_m');
			$this->load->library('forminput');	
			$this->load->library('form_validation');
			$this->load->library('form_engine');
			$this->load->library('Querylib');
			$this->load->library('datatables');
			$this->load->library('upload');
		}else{
			//If no session, redirect to login page
			redirect('admin/login', 'refresh');
		}
		
	}
	
	function index(){
			$session_data = $this->session->userdata('sht_ssndata');

			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;
			$data["gettreatmnt"] = $this->registration_m->get_treattype();	
			$data["gettimeslot"] = $this->registration_m->get_time(); 
			$this->load->view('appointment',$data);
	}

	public function appointment_data(){	

		$multidata = $this->input->post('mldata');
		/*if (!empty($multidata)) {
			foreach($multidata as $dt){
				echo $dt.'<br>';
			}
		}
		
		print_r($multidata); exit;	*/
		//$this->is_ajax();
		$session_data = $this->session->userdata('sht_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
								array('field'   => 'email', 'label'   => 'Email Address', 'rules'   => 'valid_email', 'errors'),
								array('field'   => 'phone', 'label'   => 'Phone Number', 'rules'   => 'trim|xss_clean|required'),
								array('field'   => 'gender', 'label'   => 'Gender', 'rules'   => 'trim|xss_clean|required'),
								array('field'   => 'apnmtdate', 'label'   => 'Appointment Date', 'rules'   => 'trim|xss_clean|required'),
								array('field'   => 'timeslot', 'label'   => 'Time slot', 'rules'   => 'trim|xss_clean|required'),

			);
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
            echo $errors_array;
        else{
				//Setting values for tabel columns
				$data = array(
					'patient_name'=>$this->input->post('name'),
					'email'=>$this->input->post('email'),
					'gender'=>$this->input->post('gender'),
					'dateofbirth'=>date("Y-m-d", strtotime($this->input->post('dob'))),
					'age'=>$this->input->post('age'),
					'phone'=>$this->input->post('phone'),
					/*'category'=>$this->input->post('category'),*/
					'appointment_date'=>date("Y-m-d", strtotime($this->input->post('apnmtdate'))),
					'time_slot'=>$this->input->post('timeslot'),
					'address'=>$this->input->post('address'),	
					'note'=>$this->input->post('note'),
					'special_request'=>$this->input->post('special_request'),	
					'added_by'=>$session_data['id'],				
				);

				//Transfering data to Model
				$id = $this->registration_m->regi_insert($data);
				
				if (!empty($multidata)) {
					foreach($multidata as $dt){
						 $tdata = array(
						 		'appointment_id' => $id,
						 		'apt_treatment_id' => $dt,
						 );

						 $this->registration_m->treatment_insert($tdata);
					}
				}



				echo $errors_array.'Appointment Added Successfully';					
			
		}
	}

	function appointment_list(){
			$session_data = $this->session->userdata('sht_ssndata');

			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;	
			$data["apnmentlist"] = $this->registration_m->get_anmtListall();	  
			$this->load->view('patient_list',$data);
	}


	public function get_appointment(){
		$session_data = $this->session->userdata('sht_ssndata');
		$metadata = array(
			'title' => 'Appointment List',
			'description' => 'Appointment List',
			'keywords' => 'Appointment',
			'imagesurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'page' => 'indes',
		);

		$data['metadata'] = $metadata;
		$data['page'] = 1;
		$data['getlist'] = $this->registration_m->get_anmtListall();
		$this->load->view('test', $data);
	}

	function editapt($id){
        $session_data = $this->session->userdata('sht_ssndata');	
        $metadata = array(
					'title' => 'center',
					'description' => '',
					'keywords' => '',
					'heading' => 'center',
					'imageurl' => base_url('user/images/logo.png'),
					'siteurl' => base_url(''),
					'imageuploadurl' => base_url('a_imageupload'),				
					'id' => $session_data['id'],
					'user_login' => $session_data['user_login'],
					'display_name' => $session_data['display_name'],
					'user_type' => $session_data['user_type'],
					'center_id' => $session_data['user_clinic'],
					'page' => 'center',				
				);
				$data["metadata"] = $metadata;
				$data["editdata"] = 'setup/edit_staff_data/'.$id;
				$data["info"] = $this->registration_m->get_appointmentdata($id);
				$data["gettreatmnt"] = $this->registration_m->get_treattype();	
				$data["gettimeslot"] = $this->registration_m->get_time();
		
        $this->load->view('appointment_edit', $data);
     }


	

	function clearcache(){    	
		$this->output->clear_all_cache();
		redirect('admin', 'refresh');		
  	} //End of function
	
}

?>

