<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Appointment extends Ci_Controller {
	
	
	function __construct(){  	
		parent::__construct();
		
		if($this->session->userdata('sht_ssndata')){
			$this->load->model('registration_m');
			$this->load->library('tags');
			$this->load->library('imagecrop');
			
			$this->load->library('forminput');			
			$this->load->library('form_validation');
			
			$this->load->library('datatables');
			$this->load->library('Querylib');
        		$this->load->library('table');
			
			$this->load->library('form_engine');
					
		}else{
			//If no session, redirect to login page
			redirect('admin/login', 'refresh');
		}		
  	}

  	/*--------- appointment -------*/
  	public function index(){
		
		$session_data = $this->session->userdata('sht_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'center_id' => $session_data['user_clinic'],		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'appointment/new_center_data';
		$data["gettreatmnt"] = $this->registration_m->get_treattype();	
		$data["gettimeslot"] = $this->registration_m->get_time(); 
		$data["getapttime"] = $this->registration_m->get_apttime();
		$this->load->view('appointment',$data);
		
	}

public function appointmencustomer(){
		
		$session_data = $this->session->userdata('sht_ssndata');			
		$metadata = array(
			'title' => 'center',
			'description' => '',
			'keywords' => '',
			'heading' => 'center',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'imageuploadurl' => base_url('a_imageupload'),				
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'center_id' => $session_data['user_clinic'],		
			'page' => 'center',				
			);
		$data["metadata"] = $metadata;
		$data["newpatient_database"] = 'appointment/new_center_data';
		$data["gettreatmnt"] = $this->registration_m->get_treattype();	
		$data["gettimeslot"] = $this->registration_m->get_time(); 
		$data["getapttime"] = $this->registration_m->get_apttime();
		$this->load->view('appointment_customer',$data);
		
	}



public function fetch_endtime(){
	if($this->input->post('sttime')){
		echo $this->registration_m->get_endtime($this->input->post('sttime'));
	}
}

public function gettrmnt(){
	$data["apptdate"] = date("Y-m-d", strtotime($this->input->post('apdt')));
	$data["starttime"] = $this->input->post('sttime');
	$data["endtime"] = $this->input->post('endtime');
	$data["gettreatmnt"] = $this->registration_m->get_treattype();
	$this->load->view('treatment',$data);
}
	

     public function new_center_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('sht_ssndata');

		$aptdate = date("Y-m-d", strtotime($this->input->post('apnmtdate')));
		$st = $this->input->post('start_time');
		$end = $this->input->post('end_time');
		$multidata = $this->input->post('mldata');
		
		
		//This method will have the credentials validation
		$validation_rules = array(
	               	array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'email', 'label'   => 'Email Address', 'rules'   => 'valid_email', 'errors'),
			array('field'   => 'phone', 'label'   => 'Phone Number', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'gender', 'label'   => 'Gender', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'apnmtdate', 'label'   => 'Appointment Date', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'lable', 'label'   => 'Lable', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'start_time', 'label'   => 'Start Time', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'end_time', 'label'   => 'End Time', 'rules'   => 'trim|xss_clean|required'),
	        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{

	        	$dobdate = $this->input->post('dob');
	        	if (!empty($dobdate)) {
	        		$dob = date("Y-m-d", strtotime($this->input->post('dob')));
	        	}else{
	        		$dob = null;
	        	}	        	

			//Setting values for tabel columns
			$data = array(
				'patient_name'=>$this->input->post('name'),
				'email'=>$this->input->post('email'),
				'gender'=>$this->input->post('gender'),
				'dateofbirth'=>$dob,
				'age'=>$this->input->post('age'),
				'phone'=>$this->input->post('phone'),
				'appointment_date'=>date("Y-m-d", strtotime($this->input->post('apnmtdate'))),
				'address'=>$this->input->post('address'),	
				'note'=>$this->input->post('note'),
				'special_request'=>$this->input->post('special_request'),
				'lable'=>$this->input->post('lable'),
				'start_time'=>$this->input->post('start_time'),
				'end_time'=>$this->input->post('end_time'),	
				'added_by'=>$session_data['id'],
				'clinic'=>$session_data['user_clinic']
			);
			//Transfering data to Model
			$id = $this->registration_m->regi_insert($data);
			
			if (!empty($multidata)) {
				foreach($multidata as $dt){
					$tdata = array(
						'appointment_id' => $id,
						'apt_treatment_id' => $dt,
					);
					$this->registration_m->treatment_insert($tdata);
				}
			}
			echo $errors_array.'Appointment Added Successfully';						
			
		}
	}

	function appointment_list(){
			$session_data = $this->session->userdata('sht_ssndata');

			$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
				);
			$data["metadata"] = $metadata;			
			$data["page"] = 1;	
			$data["apnmentlist"] = $this->registration_m->get_anmtListall();	  
			$this->load->view('patient_list',$data);
	}

function editapt($id){
        $session_data = $this->session->userdata('sht_ssndata');	
        $metadata = array(
		'title' => 'center',
		'description' => '',
		'keywords' => '',
		'heading' => 'center',
		'imageurl' => base_url('user/images/logo.png'),
		'siteurl' => base_url(''),
		'imageuploadurl' => base_url('a_imageupload'),				
		'id' => $session_data['id'],
		'user_login' => $session_data['user_login'],
		'display_name' => $session_data['display_name'],
		'user_type' => $session_data['user_type'],
		'center_id' => $session_data['user_clinic'],
		'page' => 'center',				
	);
	$data["metadata"] = $metadata;
	$data["editdata"] = 'appointment/edit_apt_data/'.$id;
	$data["info"] = $this->registration_m->get_appointmentdata($id);
	$data["gettreatmnt"] = $this->registration_m->get_treattype();	
	$data["gettimeslot"] = $this->registration_m->get_time();
	$data["getapttime"] = $this->registration_m->get_apttime();
		
        $this->load->view('edit', $data);
    }
	
 public function edit_apt_data($id){		
	//$this->is_ajax();
	$session_data = $this->session->userdata('sht_ssndata');
	//This method will have the credentials validation
	$validation_rules = array(
	           array('field'   => 'name', 'label'   => 'Name', 'rules'   => 'trim|xss_clean|required'),
		   array('field'   => 'email', 'label'   => 'Email Address', 'rules'   => 'valid_email', 'errors'),
		   array('field'   => 'phone', 'label'   => 'Phone Number', 'rules'   => 'trim|xss_clean|required'),
		   array('field'   => 'gender', 'label'   => 'Gender', 'rules'   => 'trim|xss_clean|required'),
		   array('field'   => 'apnmtdate', 'label'   => 'Appointment Date', 'rules'   => 'trim|xss_clean|required'),
		   /*array('field'   => 'timeslot', 'label'   => 'Time slot', 'rules'   => 'trim|xss_clean|required'),*/               	
	       );
	$errors_array = $this->form_validation->validation($validation_rules);
	if($errors_array)
	     echo $errors_array;
	else{
		$infodata = $this->registration_m->get_appointmentdata($id);
		$apthistory = array(
				'patient_name'=>$infodata->patient_name,
				'email'=>$infodata->email,
				'gender'=>$infodata->gender,
				'dateofbirth'=>$infodata->dateofbirth,
				'age'=>$infodata->age,
				'phone'=>$infodata->phone,
				'appointment_date'=>$infodata->appointment_date,
				'lable'=>$infodata->lable,
				'start_time'=>$infodata->start_time,
				'end_time'=>$infodata->end_time,
				'address'=>$infodata->address,	
				'note'=>$infodata->note,
				'special_request'=>$infodata->special_request,	
				'added_by'=>$infodata->added_by,
				'clinic'=>$infodata->clinic,
				'apt_id'=>$id
			);
		$hid = $this->registration_m->history_insert($apthistory);
		$infotrtdt = $this->registration_m->get_treamntdata($id);
		foreach($infotrtdt as $th){
			$tdata = array(
					'apthistory_id' => $hid,
					'apt_treatment_id' => $th->apt_treatment_id,
				);
			$this->registration_m->trmnt_history_insert($tdata);
		}

	//Setting values for tabel columns
		$data = array(
			'patient_name'=>$this->input->post('name'),
			'email'=>$this->input->post('email'),
			'gender'=>$this->input->post('gender'),
			'dateofbirth'=>date("Y-m-d", strtotime($this->input->post('dob'))),
			'age'=>$this->input->post('age'),
			'phone'=>$this->input->post('phone'),
			'appointment_date'=>date("Y-m-d", strtotime($this->input->post('apnmtdate'))),
			/*'time_slot'=>$this->input->post('timeslot'),*/
			'start_time'=>$this->input->post('start_time'),
			'end_time'=>$this->input->post('end_time'),
			'address'=>$this->input->post('address'),	
			'note'=>$this->input->post('note'),
			'special_request'=>$this->input->post('special_request'),
			'lable'=>$this->input->post('lable'),	
			'modify_by'=>$session_data['id'],
		);

		//Transfering data to Model
		$this->registration_m->apt_update($data, $id);

		$this->registration_m->removetrmn($id);

		$multidata = $this->input->post('mldata');
		if (!empty($multidata)) {

			foreach($multidata as $dt){
				$tdata = array(
					'appointment_id' => $id,
					'apt_treatment_id' => $dt,
				);
				$this->registration_m->treatment_insert($tdata);
			}
		}

		echo $errors_array.'Update Successfully';
	}
}

function cancel_apt()  
      {
         $id = $_POST["id"]; 
         $aptdata = array(
				'status'=>2,
			);
	 //Transfering data to Model
	 $this->registration_m->apt_update($aptdata, $id);          
         echo 'Appointment Canceled';  
      }
function restor_apt()  
      {
         $id = $_POST["id"]; 
         $aptdata = array(
				'status'=>0,
			);
	 //Transfering data to Model
	 $this->registration_m->apt_update($aptdata, $id);          
         echo 'Appointment Restored';  
      }
function aptschedule($id){
        $session_data = $this->session->userdata('sht_ssndata');	
        $metadata = array(
		'title' => 'center',
		'description' => '',
		'keywords' => '',
		'heading' => 'center',
		'imageurl' => base_url('user/images/logo.png'),
		'siteurl' => base_url(''),
		'imageuploadurl' => base_url('a_imageupload'),				
		'id' => $session_data['id'],
		'user_login' => $session_data['user_login'],
		'display_name' => $session_data['display_name'],
		'user_type' => $session_data['user_type'],
		'center_id' => $session_data['user_clinic'],
		'page' => 'center',				
	);
	$data["metadata"] = $metadata;
	$data["editdata"] = 'appointment/new_schedule_data/'.$id;
	$data["info"] = $this->registration_m->get_appointmentdata($id);
	$data["getapttrtmnt"] = $this->registration_m->get_apnttreatmnt($id);
	$data["gettreatmnt"] = $this->registration_m->get_treattype();	
	$data["gettimeslot"] = $this->registration_m->get_time();
	$data["getdr"] = $this->registration_m->get_doctor();
	$data["getnurse"] = $this->registration_m->get_nurse();
	$data["getroom"] = $this->registration_m->get_room();
        $this->load->view('schedule', $data);
    }

public function new_schedule_data($id){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('sht_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(
	               	/*array('field'   => 'room_id', 'label'   => 'Room', 'rules'   => 'trim|xss_clean|required'),*/
			array('field'   => 'treatment_date', 'label'   => 'Date', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'treatment_start', 'label'   => 'Start Time', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'treatment_end', 'label'   => 'End Time', 'rules'   => 'trim|xss_clean|required'),
			/*array('field'   => 'doctor_id', 'label'   => 'Doctor', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'staff_id', 'label'   => 'Nurse', 'rules'   => 'trim|xss_clean|required'),*/
	        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{
			//Setting values for tabel columns
			$data = array(
				'room_id'=>$this->input->post('room_id'),
				'doctor_id'=>$this->input->post('doctor_id'),
				/*'treatment_time'=>$this->input->post('treatment_time'),*/
				'treatment_date'=>date("Y-m-d", strtotime($this->input->post('treatment_date'))),
				'staff_id'=>$this->input->post('staff_id'),
				'sdl_lable'=>$this->input->post('lable'),
				'treatment_start'=>$this->input->post('treatment_start'),
				'treatment_end'=>$this->input->post('treatment_end'),									
				'created_by'=>$session_data['id'],
				'appointment_id'=>$id
			);
			//Transfering data to Model
			$sid = $this->registration_m->schedule_insert($data);

			$aptdata = array(
				'status'=>1,
			);
			//Transfering data to Model
			$this->registration_m->apt_update($aptdata, $id);
			
			echo $errors_array.'Added Successfully';						
			
		}
	}

function schedule_list(){
		$session_data = $this->session->userdata('sht_ssndata');
		$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
			);
		$data["metadata"] = $metadata;			
		$data["page"] = 1;	
		$data["apnmentlist"] = $this->registration_m->get_schedule();

		$this->load->view('schedule_list',$data);
	}

function aptschedule_edit($id){
        $session_data = $this->session->userdata('sht_ssndata');	
        $metadata = array(
		'title' => 'center',
		'description' => '',
		'keywords' => '',
		'heading' => 'center',
		'imageurl' => base_url('user/images/logo.png'),
		'siteurl' => base_url(''),
		'imageuploadurl' => base_url('a_imageupload'),				
		'id' => $session_data['id'],
		'user_login' => $session_data['user_login'],
		'display_name' => $session_data['display_name'],
		'user_type' => $session_data['user_type'],
		'center_id' => $session_data['user_clinic'],
		'page' => 'center',				
	);
	$data["metadata"] = $metadata;
	$data["editdata"] = 'appointment/edit_scheduledata/'.$id;
	$data["info"] = $this->registration_m->get_sheduledata($id);
	/*$data["getapttrtmnt"] = $this->registration_m->get_apnttreatmnt($id);*/
	$data["gettreatmnt"] = $this->registration_m->get_treattype();	
	$data["gettimeslot"] = $this->registration_m->get_time();
	$data["getdr"] = $this->registration_m->get_doctor();
	$data["getnurse"] = $this->registration_m->get_nurse();
	$data["getroom"] = $this->registration_m->get_room();

	/*print_r($data["info"]);exit;*/

        $this->load->view('schedule_edit', $data);
    }


public function edit_scheduledata($id){		
	//$this->is_ajax();
	$session_data = $this->session->userdata('sht_ssndata');
	//This method will have the credentials validation
	$validation_rules = array(
	           /*array('field'   => 'room_id', 'label'   => 'Room', 'rules'   => 'trim|xss_clean|required'),*/
		   array('field'   => 'treatment_date', 'label'   => 'Date', 'rules'   => 'trim|xss_clean|required'),
		   /*array('field'   => 'treatment_time', 'label'   => 'Time', 'rules'   => 'trim|xss_clean|required'),
		   array('field'   => 'doctor_id', 'label'   => 'Doctor', 'rules'   => 'trim|xss_clean|required'),
		   array('field'   => 'staff_id', 'label'   => 'Nurse', 'rules'   => 'trim|xss_clean|required'),*/              	
	       );
	$errors_array = $this->form_validation->validation($validation_rules);
	if($errors_array)
	     echo $errors_array;
	else{		
		$data = array(
				'room_id'=>$this->input->post('room_id'),
				'doctor_id'=>$this->input->post('doctor_id'),
				/*'treatment_time'=>$this->input->post('treatment_time'),*/
				'treatment_date'=>date("Y-m-d", strtotime($this->input->post('treatment_date'))),
				'treatment_start'=>$this->input->post('treatment_start'),
				'treatment_end'=>$this->input->post('treatment_end'),
				'staff_id'=>$this->input->post('staff_id'),
				'status'=>$this->input->post('status'),					
				'modify_by'=>$session_data['id'],
			);
	
		//Transfering data to Model
		$this->registration_m->schedule_update($data, $id);
		echo $errors_array.'Update Successfully';
	}
}

function schedule_status_change()  
      {
         $id = $_POST["id"];
         $stssdl = $_POST["sdlstatus"];
         $aptdata = array(
				'status'=>$stssdl,
			);
	 //Transfering data to Model
	 $this->registration_m->schedule_update($aptdata, $id);          
         echo 'Schedule status has been changed';  
      }



public function search(){ 
        $term = $this->input->get('term'); 
        $this->db->like('ptname', $term);
        $this->db->or_like('pttelcel', $term);
        $data = $this->db->get("drindr_patient")->result(); 
        echo json_encode( $data);
    }

public function customer_from(){  
     	$mbrid = $this->input->post('id');
     	$mbrnm = $this->input->post('csname');		
	$data["csdtl"] = $this->registration_m->customer_data($mbrid,$mbrnm);
	$data["gettreatmnt2"] = $this->registration_m->get_treattype();	
	$data["gettimeslot2"] = $this->registration_m->get_time(); 
	$data["getapttime"] = $this->registration_m->get_apttime();
	$this->load->view('viewcustomer',$data);		
}//end function

public function schedule_dtl(){  
     	$mbrid = $this->input->post('id');		
	$data["schdl"] = $this->registration_m->view_sheduledata($mbrid);
	$this->load->view('viewschedule',$data);			
}//end function

public function apteidit_history(){  
     	$aptid = $this->input->post('id');		
	$data["apthstry"] = $this->registration_m->get_aptHistory($aptid);
	$this->load->view('edithistory',$data);			
}//end function



public function customeapt_data(){		
		//$this->is_ajax();
		$session_data = $this->session->userdata('sht_ssndata');	
		//This method will have the credentials validation
		$validation_rules = array(	               	
			array('field'   => 'capnmtdate', 'label'   => 'Appointment Date', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'start_time', 'label'   => 'Start Time', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'end_time', 'label'   => 'End Time', 'rules'   => 'trim|xss_clean|required'),
			array('field'   => 'clable', 'label'   => 'Lable', 'rules'   => 'trim|xss_clean|required'),
	        );
		$errors_array = $this->form_validation->validation($validation_rules);
		if($errors_array)
	            echo $errors_array;
	        else{
			//Setting values for tabel columns
			$data = array(
				'patient_name'=>$this->input->post('cname'),
				'email'=>$this->input->post('cemail'),
				'gender'=>$this->input->post('cgender'),
				'dateofbirth'=>date("Y-m-d", strtotime($this->input->post('cdob'))),
				'phone'=>$this->input->post('cphone'),
				'appointment_date'=>date("Y-m-d", strtotime($this->input->post('capnmtdate'))),
				/*'time_slot'=>$this->input->post('ctimeslot'),*/
				'address'=>$this->input->post('caddress'),	
				'note'=>$this->input->post('cnote'),
				'special_request'=>$this->input->post('cspecial_request'),
				'customer_entryno'=>$this->input->post('cid'),
				'lable'=>$this->input->post('clable'),
				'start_time'=>$this->input->post('start_time'),
				'end_time'=>$this->input->post('end_time'),
				'existing_customer'=>1,	
				'added_by'=>$session_data['id'],
				'clinic'=>$session_data['user_clinic']
			);
			//Transfering data to Model
			$id = $this->registration_m->regi_insert($data);
			$multidata = $this->input->post('mldata');
			if (!empty($multidata)) {
				foreach($multidata as $dt){
					$tdata = array(
						'appointment_id' => $id,
						'apt_treatment_id' => $dt,
					);
					$this->registration_m->treatment_insert($tdata);
				}
			}
			echo $errors_array.'Appointment Added Successfully';						
			
		}
	}


public function schedulebydate(){
		$session_data = $this->session->userdata('sht_ssndata');
		$metadata = array(
				'title' => 'Dashboard',
				'description' => 'Admin Home',
				'keywords' => 'Admin Home',
				'imageurl' => base_url('user/images/logo.png'),
				'siteurl' => base_url(''),
				'id' => $session_data['id'],
				'user_login' => $session_data['user_login'],
				'display_name' => $session_data['display_name'],
				'user_type' => $session_data['user_type'],
				'page' => 'index',				
			);
		$data["metadata"] = $metadata;			
		$data["page"] = 1;		

		$sdldate = date('Y-m-d');
		
		$data["todaysdl"] = $this->registration_m->get_schedulebydate($sdldate);

		$this->load->view('schedul_filter',$data);

	}

public function sdlview(){  
     	$ptdata = $this->input->post('ptdata');		
	$data["todaysdl"] = $this->registration_m->get_schedulebydate($ptdata);
	$data["slctdt"] = $ptdata;
	$this->load->view('sdl_date',$data);			
}

public function appointmentbydate(){
	$session_data = $this->session->userdata('sht_ssndata');
	$metadata = array(
			'title' => 'Dashboard',
			'description' => 'Admin Home',
			'keywords' => 'Admin Home',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'page' => 'index',				
		);
	$data["metadata"] = $metadata;
	$sdldate = date('Y-m-d');		
	$data["todayapnmt"] = $this->registration_m->get_anmtListToday($sdldate);
	$this->load->view('appointment_filter',$data);
}

public function apnmtview(){  
	$session_data = $this->session->userdata('sht_ssndata');
	$metadata = array(
			'title' => 'Dashboard',
			'description' => 'Admin Home',
			'keywords' => 'Admin Home',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'page' => 'index',				
		);
	$data["metadata"] = $metadata;
    $ptdata = $this->input->post('ptdata');		
	$data["todayapnmt"] = $this->registration_m->get_anmtListToday($ptdata);
	$data["slctdt"] = $ptdata;
	$this->load->view('apnt_date',$data);			
}

public function appoinmtbox(){
	$session_data = $this->session->userdata('sht_ssndata');
	$metadata = array(
			'title' => 'Dashboard',
			'description' => 'Admin Home',
			'keywords' => 'Admin Home',
			'imageurl' => base_url('user/images/logo.png'),
			'siteurl' => base_url(''),
			'id' => $session_data['id'],
			'user_login' => $session_data['user_login'],
			'display_name' => $session_data['display_name'],
			'user_type' => $session_data['user_type'],
			'page' => 'index',				
		);
	$data["metadata"] = $metadata;
	$sdldate = date('Y-m-d');		
	$data["todayapnmt"] = $this->registration_m->get_anmtListToday($sdldate);
	$data["getslot"] = $this->registration_m->get_time();
	$this->load->view('apt_box',$data);
}


function is_ajax(){
	if (!$this->input->is_ajax_request()) {
            if($this->session->userdata('sht_ssndata')){			
			redirect('admin', 'refresh');						
		}else{
			redirect('admin/login', 'refresh');
		}
	}
}

public function rndmhabijabi(){
	$data['metadata'] = 'all-don';
}
	

	
} // End Class

?>