<?php
/**
 * The template part for Top Header
 *
 * @package Makeup Artist
 * @subpackage makeup-artist
 * @since makeup-artist 1.0
 */
?>

<div class="top-header">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-6 contact align-self-center">
                <?php if(get_theme_mod('makeup_artist_phone_number') != '' || get_theme_mod('makeup_artist_phone_text') != ''){ ?>
                    <div class="row">
                        <div class="col-lg-2 col-md-2 col-2 align-self-center text-center">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="col-lg-10 col-md-10 col-10 align-self-center">
                            <?php if(get_theme_mod('makeup_artist_phone_number') != '') {?>
                                <a href="tel:<?php echo esc_attr(get_theme_mod('makeup_artist_phone_number')); ?>"><?php echo esc_html(get_theme_mod('makeup_artist_phone_number')); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('makeup_artist_phone_text')); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('makeup_artist_phone_text') != '') {?>
                                <p class="contact-text mb-0"><?php echo esc_html(get_theme_mod('makeup_artist_phone_text')); ?></p>
                            <?php }?>
                        </div>
                    </div>
                <?php }?>
            </div>
            <div class="col-lg-3 col-md-6 contact align-self-center">
                <?php if(get_theme_mod('makeup_artist_timing') != '' || get_theme_mod('makeup_artist_timing_text') != ''){ ?>
                    <div class="row">
                        <div class="col-lg-2 col-md-2 col-2 align-self-center text-center">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="col-lg-10 col-md-10 col-10 align-self-center pe-md-0">
                            <?php if(get_theme_mod('makeup_artist_timing') != '') {?>
                                <p class="timing mb-0"><?php echo esc_html(get_theme_mod('makeup_artist_timing')); ?></p>
                            <?php }?>
                            <?php if(get_theme_mod('makeup_artist_timing_text') != '') {?>
                                <p class="contact-text mb-0"><?php echo esc_html(get_theme_mod('makeup_artist_timing_text')); ?></p>
                            <?php }?>
                        </div>
                    </div>
                <?php }?>
            </div>
            <div class="col-lg-3 col-md-6 contact align-self-center">
                <?php if(get_theme_mod('makeup_artist_email_address') != '' || get_theme_mod('makeup_artist_email_text') != ''){ ?>
                    <div class="row">
                        <div class="col-lg-2 col-md-2 col-2 align-self-center text-center">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="col-lg-10 col-md-10 col-10 align-self-center pe-md-0">
                            <?php if(get_theme_mod('makeup_artist_email_address') != '') {?>
                                <a href="mailto:<?php echo esc_attr(get_theme_mod('makeup_artist_email_address')); ?>"><?php echo esc_html(get_theme_mod('makeup_artist_email_address')); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('makeup_artist_email_address')); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('makeup_artist_email_text') != '') {?>
                                <p class="contact-text mb-0"><?php echo esc_html(get_theme_mod('makeup_artist_email_text')); ?></p>
                            <?php }?>
                        </div>
                    </div>
                <?php }?>
            </div>
            <div class="col-lg-3 col-md-6 ps-md-0 align-self-center">
                <div class="social-icons text-md-end text-start">
                    <?php dynamic_sidebar('topbar-social-icons'); ?>
                </div>
            </div>
        </div>
    </div>
</div>