<?php
/**
 * The template part for Middle Header
 *
 * @package Makeup Artist
 * @subpackage makeup-artist
 * @since makeup-artist 1.0
 */
?>

<div class="main-header">
  <div class="row">
    <div class="col-lg-3 col-md-4 ps-lg-5 ps-md-4 logo-bg">
      <div class="logo text-md-start text-center">
        <?php if ( has_custom_logo() ) : ?>
          <div class="site-logo"><?php the_custom_logo(); ?></div>
        <?php endif; ?>
        <?php $blog_info = get_bloginfo( 'name' ); ?>
          <?php if ( ! empty( $blog_info ) ) : ?>
            <?php if ( is_front_page() && is_home() ) : ?>
              <?php if( get_theme_mod('makeup_artist_logo_title_hide_show',true) != ''){ ?>
                <h1 class="site-title mb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
              <?php } ?>
            <?php else : ?>
              <?php if( get_theme_mod('makeup_artist_logo_title_hide_show',true) != ''){ ?>
                <p class="site-title mb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
              <?php } ?>
            <?php endif; ?>
          <?php endif; ?>
          <?php
            $description = get_bloginfo( 'description', 'display' );
            if ( $description || is_customize_preview() ) :
          ?>
          <?php if( get_theme_mod('makeup_artist_tagline_hide_show',true) != ''){ ?>
            <p class="site-description mb-0">
              <?php echo esc_html($description); ?>
            </p>
          <?php } ?>
        <?php endif; ?>
      </div>
    </div>
    <div class="col-lg-9 col-md-8 align-self-center ps-md-0">
      <?php get_template_part('template-parts/header/top-header'); ?>
      <div class="row mx-md-0">
        <div class="<?php if(get_theme_mod('makeup_artist_appointment_btn_url') != '' || get_theme_mod('makeup_artist_appointment_btn_text') != ''){ ?>col-lg-9 col-md-7<?php } else {?> col-lg-12 col-md-12 <?php }?> ps-lg-5 align-self-center">
          <?php get_template_part('template-parts/header/navigation'); ?>
        </div>
        <?php if(get_theme_mod('makeup_artist_appointment_btn_url') != '' || get_theme_mod('makeup_artist_appointment_btn_text') != ''){ ?>
          <div class="col-lg-3 col-md-5 appointment-btn">
            <a href="<?php echo esc_url(get_theme_mod('makeup_artist_appointment_btn_url')); ?>"><?php echo esc_html(get_theme_mod('makeup_artist_appointment_btn_text')); ?><i class="fas fa-angle-double-right ms-2"></i><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('makeup_artist_appointment_btn_text')); ?></span></a>
          </div>
        <?php }?> 
      </div>
    </div>
  </div>
</div>