<?php
/**
 * Template Name: Custom Home Page
 */

get_header(); ?>

<main id="maincontent" role="main">
  <?php do_action( 'makeup_artist_before_slider' ); ?>

  <div class="slider-quote position-relative">
    <?php if( get_theme_mod( 'makeup_artist_slider_hide_show', false) != '' || get_theme_mod( 'makeup_artist_resp_slider_hide_show', false) != '') { ?>
      <section id="slider">        
        <div id="carouselExampleInterval" class="carousel carousel-fade" data-bs-ride="carousel" data-bs-interval="<?php echo esc_attr(get_theme_mod( 'makeup_artist_slider_speed',4000)) ?>">
          <?php $makeup_artist_pages = array();
            for ( $count = 1; $count <= 4; $count++ ) {
              $mod = intval( get_theme_mod( 'makeup_artist_slider_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $makeup_artist_pages[] = $mod;
              }
            }
            if( !empty($makeup_artist_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $makeup_artist_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
              if ( $query->have_posts() ) :
                $i = 1;
          ?>
          <div class="carousel-inner" role="listbox">
            <?php while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
                <?php if(has_post_thumbnail()){
                  the_post_thumbnail();
                } else{?>
                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/block-patterns/images/slider.png" alt="" />
                <?php } ?>
                <div class="carousel-caption">
                  <div class="inner_carousel">
                    <?php if( get_theme_mod('makeup_artist_slider_title_hide_show',true) != ''){ ?>
                      <h1 class="wow bounceInUp delay-1000" data-wow-duration="2s"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
                    <?php }?>
                    <?php if( get_theme_mod('makeup_artist_slider_content_hide_show',true) != ''){ ?>
                      <p class="wow bounceInUp delay-1000" data-wow-duration="2s"><?php $excerpt = get_the_excerpt(); echo esc_html( makeup_artist_string_limit_words( $excerpt, esc_attr(get_theme_mod('makeup_artist_slider_excerpt_number','20')))); ?></p>
                    <?php } ?>
                    <div class="read-btn wow bounceInUp delay-1000" data-wow-duration="2s">
                      <a href="<?php the_permalink(); ?>"><?php echo esc_html('Read More','makeup-artist'); ?><span class="screen-reader-text"><?php echo esc_html('Read More','makeup-artist'); ?></span></a>
                    </div>
                  </div>
                </div>
              </div>
            <?php $i++; endwhile; 
            wp_reset_postdata();?>
          </div>
          <?php else : ?>
            <div class="no-postfound"></div>
          <?php endif;
          endif;?>
          <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval" id="prev" data-bs-slide="prev">
          <i class="fas fa-angle-left" aria-hidden="true"></i>
          <span class="screen-reader-text"><?php echo esc_html('Previous','makeup-artist'); ?></span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="next" id="next">
          <i class="fas fa-angle-right" aria-hidden="true"></i>
          <span class="screen-reader-text"><?php echo esc_html('Next','makeup-artist'); ?></span>
          </button>
        </div> 
      </section>
    <?php }?>
    <?php if( get_theme_mod('makeup_artist_quote_text') != '' || get_theme_mod('makeup_artist_quote_link') != '' ){ ?>
      <div class="row">
        <div class="offset-lg-5 col-lg-7 position-relative">
          <div class="quoute-text py-4 text-md-end text-center pe-md-5">
            <a href="<?php echo esc_url(get_theme_mod('makeup_artist_quote_link')); ?>"><?php echo esc_html(get_theme_mod('makeup_artist_quote_text')); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('makeup_artist_quote_text')); ?></span></a>
          </div>
        </div>
      </div>
    <?php }?>
  </div>

  <?php do_action( 'makeup_artist_after_slider' ); ?>

  <?php if(get_theme_mod('makeup_artist_section_title') != '' || get_theme_mod('makeup_artist_product_category') != '') {?>
    <section id="service-section" class="py-5 wow slideInRight delay-1000" data-wow-duration="2s">
      <div class="container">
        <div class="service-head text-center">
          <?php if( get_theme_mod('makeup_artist_section_small_title') != '' ){ ?>
            <strong class="small-title"><?php echo esc_html(get_theme_mod('makeup_artist_section_small_title'));?></strong>
          <?php }?>
          <?php if( get_theme_mod('makeup_artist_section_title') != '' ){ ?>
            <h2 class="text-center"><?php echo esc_html(get_theme_mod('makeup_artist_section_title'));?></h2>
          <?php }?>
          <?php if( get_theme_mod('makeup_artist_section_text') != '' ){ ?>
            <p class="mb-0"><?php echo esc_html(get_theme_mod('makeup_artist_section_text'));?></p>
          <?php }?>
        </div>
        <div class="row">
          <?php
          $makeup_artist_catData = get_theme_mod('makeup_artist_service_category');
          if($makeup_artist_catData){
            $page_query = new WP_Query(array( 'category_name' => esc_html( $makeup_artist_catData ,'makeup-artist')));
            while( $page_query->have_posts() ) : $page_query->the_post(); ?>
              <div class="col-lg-4 col-md-6">
                <div class="service-box wow zoomIn" data-wow-duration="2s">
                  <div class="row mx-md-0">
                    <div class="col-lg-6 col-md-6 col-6 ps-md-0 align-self-end">
                      <div class="bx-image"><?php the_post_thumbnail(); ?></div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-6">
                      <div class="service-content">
                        <?php if( get_post_meta($post->ID, 'makeup_artist_expertise', true) ) {?>
                          <div class="meta-feilds">
                            <?php if( get_post_meta($post->ID, 'makeup_artist_expertise', true) ) {?>
                              <span class="expertise"><?php echo esc_html(get_post_meta($post->ID,'makeup_artist_expertise',true)); ?></span>
                            <?php }?>
                          </div>
                        <?php }?>
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                        <div class="read-btn">
                          <a href="<?php the_permalink(); ?>"><?php echo esc_html('READ MORE','makeup-artist'); ?><span class="screen-reader-text"><?php echo esc_html('READ MORE','makeup-artist'); ?></span></a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_postdata();
          } ?>
        </div>
      </div>
    </section>
  <?php }?>

  <?php do_action( 'makeup_artist_after_service' ); ?>

  <div id="content-vw" class="py-3">
    <div class="container">
      <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; // end of the loop. ?>
    </div>
  </div>
</main>

<?php get_footer(); ?>