<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package Makeup Artist
 */

if ( ! function_exists( 'makeup_artist_the_attached_image' ) ) :
/**
 * Prints the attached image with a link to the next attached image.
 */
function makeup_artist_the_attached_image() {
	$post                = get_post();
	$attachment_size     = apply_filters( 'makeup_artist_attachment_size', array( 1200, 1200 ) );
	$next_attachment_url = wp_get_attachment_url();
	$attachment_ids 	 = get_posts( array(
		'post_parent'    => $post->post_parent,
		'fields'         => 'ids',
		'numberposts'    =>  1,
		'post_status'    => 'inherit',
		'post_type'      => 'attachment',
		'post_mime_type' => 'image',
		'order'          => 'ASC',
		'orderby'        => 'menu_order ID'
	) );

	wp_reset_postdata();

	// If there is more than 1 attachment in a gallery...
	if ( count( $attachment_ids ) > 1 ) {
		foreach ( $attachment_ids as $attachment_id ) {
			if ( $attachment_id == $post->ID ) {
				$next_id = current( $attachment_ids );
				break;
			}
		}

		// get the URL of the next image attachment...
		if ( $next_id )
			$next_attachment_url = get_attachment_link( $next_id );

		// or get the URL of the first image attachment.
		else
			$next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
	}

	printf( '<a href="%1$s" rel="attachment">%2$s</a>',
		esc_url( $next_attachment_url ),
		wp_get_attachment_image( $post->ID, $attachment_size )
	);
}
endif;

/**
 * Returns true if a blog has more than 1 category
 */
function makeup_artist_categorized_blog() {
	if ( false === ( $makeup_artist_all_the_cool_cats = get_transient( 'makeup_artist_all_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$makeup_artist_all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts
		$makeup_artist_all_the_cool_cats = count( $makeup_artist_all_the_cool_cats );

		set_transient( 'makeup_artist_all_the_cool_cats', $makeup_artist_all_the_cool_cats );
	}

	if ( '1' != $makeup_artist_all_the_cool_cats ) {
		// This blog has more than 1 category so makeup_artist_categorized_blog should return true
		return true;
	} else {
		// This blog has only 1 category so makeup_artist_categorized_blog should return false
		return false;
	}
}

if ( ! function_exists( 'makeup_artist_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 * @since makeup-artist
 */
function makeup_artist_the_custom_logo() {	
	the_custom_logo();
}
endif;

/**
 * Flush out the transients used in makeup_artist_categorized_blog
 */
function makeup_artist_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'makeup_artist_all_the_cool_cats' );
}
add_action( 'edit_category', 'makeup_artist_category_transient_flusher' );
add_action( 'save_post',     'makeup_artist_category_transient_flusher' );

add_theme_support( 'admin-bar', array( 'callback' => 'makeup_artist_my_admin_bar_css') );
function makeup_artist_my_admin_bar_css(){
?>
<style type="text/css" media="screen">	
	html body { margin-top: 0px !important; }
</style>
<?php
}

/*-- Custom metafield --*/
function makeup_artist_custom_expertise() {
  	add_meta_box( 'bn_meta', __( 'Makeup Artist Meta Feilds', 'makeup-artist' ), 'makeup_artist_meta_expertise_callback', 'post', 'normal', 'high' );
}
if (is_admin()){
  	add_action('admin_menu', 'makeup_artist_custom_expertise');
}

function makeup_artist_meta_expertise_callback( $post ) {
  	wp_nonce_field( basename( __FILE__ ), 'makeup_artist_expertise_meta' );
  	$bn_stored_meta = get_post_meta( $post->ID );
  	$makeup_artist_expertise = get_post_meta( $post->ID, 'makeup_artist_expertise', true );
  	?>
  	<div id="custom_meta_feilds">
	    <table id="list">
	      	<tbody id="the-list" data-wp-lists="list:meta">
		        <tr id="meta-8">
		          	<td class="left">
		            	<?php esc_html_e( 'Expertis Text', 'makeup-artist' )?>
		          	</td>
		          	<td class="left">
		            	<input type="text" name="makeup_artist_expertise" id="makeup_artist_expertise" value="<?php echo esc_html($makeup_artist_expertise); ?>" />
		          	</td>
		        </tr>
	      	</tbody>
	    </table>
  	</div>
  	<?php
}

function makeup_artist_save( $post_id ) {
  	if (!isset($_POST['makeup_artist_expertise_meta']) || !wp_verify_nonce( strip_tags( wp_unslash( $_POST['makeup_artist_expertise_meta']) ), basename(__FILE__))) {
      	return;
  	}
  	if (!current_user_can('edit_post', $post_id)) {
   		return;
  	}
  	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    	return;
  	}
  	if( isset( $_POST[ 'makeup_artist_expertise' ] ) ) {
    	update_post_meta( $post_id, 'makeup_artist_expertise', strip_tags( wp_unslash( $_POST[ 'makeup_artist_expertise' ]) ) );
  	}
}
add_action( 'save_post', 'makeup_artist_save' );