<?php
//about theme info
add_action( 'admin_menu', 'makeup_artist_gettingstarted' );
function makeup_artist_gettingstarted() {
	add_theme_page( esc_html__('About Makeup Artist', 'makeup-artist'), esc_html__('About Makeup Artist', 'makeup-artist'), 'edit_theme_options', 'makeup_artist_guide', 'makeup_artist_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function makeup_artist_admin_theme_style() {
	wp_enqueue_style('makeup-artist-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstart/getstart.css');
	wp_enqueue_script('makeup-artist-tabs', esc_url(get_template_directory_uri()) . '/inc/getstart/js/tab.js');
}
add_action('admin_enqueue_scripts', 'makeup_artist_admin_theme_style');

//guidline for about theme
function makeup_artist_mostrar_guide() { 
	//custom function about theme customizer
	$makeup_artist_return = add_query_arg( array()) ;
	$makeup_artist_theme = wp_get_theme( 'makeup-artist' );
?>

<div class="wrapper-info">
    <div class="col-left">
    	<h2><?php esc_html_e( 'Welcome to Makeup Artist', 'makeup-artist' ); ?> <span class="version"><?php esc_html_e( 'Version', 'makeup-artist' ); ?>: <?php echo esc_html($makeup_artist_theme['Version']);?></span></h2>
    	<p><?php esc_html_e('All our WordPress themes are modern, minimalist, 100% responsive, seo-friendly,feature-rich, and multipurpose that best suit designers, bloggers and other professionals who are working in the creative fields.','makeup-artist'); ?></p>
    </div>

    <div class="col-right">
    	<div class="logo">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/final-logo.png" alt="" />
		</div>
		<div class="update-now">
			<h4><?php esc_html_e('Buy Makeup Artist at 20% Discount','makeup-artist'); ?></h4>
			<h4><?php esc_html_e('Use Coupon','makeup-artist'); ?> ( <span><?php esc_html_e('vwpro20','makeup-artist'); ?></span> ) </h4>
			<div class="info-link">
				<a href="<?php echo esc_url( MAKEUP_ARTIST_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Upgrade to Pro', 'makeup-artist' ); ?></a>
			</div>
		</div>
   	</div>

    <div class="tab-sec">
    	<div class="tab">
			<button class="tablinks" onclick="makeup_artist_open_tab(event, 'lite_theme')"><?php esc_html_e( 'Setup With Customizer', 'makeup-artist' ); ?></button>
			<button class="tablinks" onclick="makeup_artist_open_tab(event, 'block_pattern')"><?php esc_html_e( 'Setup With Block Pattern', 'makeup-artist' ); ?></button>
			<button class="tablinks" onclick="makeup_artist_open_tab(event, 'gutenberg_editor')"><?php esc_html_e( 'Setup With Gutunberg Block', 'makeup-artist' ); ?></button>
			<button class="tablinks" onclick="makeup_artist_open_tab(event, 'product_addons_editor')"><?php esc_html_e( 'Woocommerce Product Addons', 'makeup-artist' ); ?></button>
			<button class="tablinks" onclick="makeup_artist_open_tab(event, 'theme_pro')"><?php esc_html_e( 'Get Premium', 'makeup-artist' ); ?></button>
		  	<button class="tablinks" onclick="makeup_artist_open_tab(event, 'free_pro')"><?php esc_html_e( 'Support', 'makeup-artist' ); ?></button>
		</div>

		<?php
			$makeup_artist_plugin_custom_css = '';
			if(class_exists('Ibtana_Visual_Editor_Menu_Class')){
				$makeup_artist_plugin_custom_css ='display: block';
			}
		?>
		<div id="lite_theme" class="tabcontent open">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
				$plugin_ins = Makeup_Artist_Plugin_Activation_Settings::get_instance();
				$makeup_artist_actions = $plugin_ins->recommended_actions;
				?>
				<div class="makeup-artist-recommended-plugins">
				    <div class="makeup-artist-action-list">
				        <?php if ($makeup_artist_actions): foreach ($makeup_artist_actions as $key => $makeup_artist_actionValue): ?>
				                <div class="makeup-artist-action" id="<?php echo esc_attr($makeup_artist_actionValue['id']);?>">
			                        <div class="action-inner">
			                            <h3 class="action-title"><?php echo esc_html($makeup_artist_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($makeup_artist_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($makeup_artist_actionValue['link']); ?>
			                            <a class="ibtana-skip-btn" get-start-tab-id="lite-theme-tab" href="javascript:void(0);"><?php esc_html_e('Skip','makeup-artist'); ?></a>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php } ?>
			<div class="lite-theme-tab" style="<?php echo esc_attr($makeup_artist_plugin_custom_css); ?>">
				<h3><?php esc_html_e( 'Lite Theme Information', 'makeup-artist' ); ?></h3>
				<hr class="h3hr">
				<p><?php esc_html_e('Makeup Artist is a stunning WordPress theme created for makeover artists, stylists, hairdressers, makeup artists, styling studios eyelash, hair studios, etc. Bloggers that love to write about makeup and cosmetics will find the layout useful. It comes with an elegant layout and professional design that will make a wonderful website giving a clean and sophisticated display of your work as a makeup artist. With retina-ready pictures depicted on its responsive layout, no resizing issues will be faced by your website. There are personalization options made available for your website along with SEO-friendly codes in the core so that getting featured in the top ranks is not a tough task anymore. Faster page load time is a result of its streamlined design and optimized codes. The Bootstrap framework makes the theme robust and easy to work with. Its mobile-friendly interface is going to give you a good website that can be accessed using mobile phones also. Interactive elements include the Call to Action Button (CTA) and stunning animations enhance the overall look and make it appear more beautiful. You will also find a wonderful banner along with several sections such as Blog, testimonial section, etc. included in the theme. Social media icons will let you take the advance of the various social media platforms for the promotion.','makeup-artist'); ?></p>
			  	<div class="col-left-inner">
			  		<h4><?php esc_html_e( 'Theme Documentation', 'makeup-artist' ); ?></h4>
					<p><?php esc_html_e( 'If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'makeup-artist' ); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( MAKEUP_ARTIST_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'makeup-artist' ); ?></a>
					</div>
					<hr>
					<h4><?php esc_html_e('Theme Customizer', 'makeup-artist'); ?></h4>
					<p> <?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'makeup-artist'); ?></p>
					<div class="info-link">
						<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'makeup-artist'); ?></a>
					</div>
					<hr>
					<h4><?php esc_html_e('Having Trouble, Need Support?', 'makeup-artist'); ?></h4>
					<p> <?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'makeup-artist'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( MAKEUP_ARTIST_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'makeup-artist'); ?></a>
					</div>
					<hr>
					<h4><?php esc_html_e('Reviews & Testimonials', 'makeup-artist'); ?></h4>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'makeup-artist'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( MAKEUP_ARTIST_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'makeup-artist'); ?></a>
					</div>

					<div class="link-customizer">
						<h3><?php esc_html_e( 'Link to customizer', 'makeup-artist' ); ?></h3>
						<hr class="h3hr">
						<div class="first-row">
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','makeup-artist'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','makeup-artist'); ?></a>
								</div>
							</div>

							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-slides"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_slidersettings') ); ?>" target="_blank"><?php esc_html_e('Slider Settings','makeup-artist'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-category"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_service_section') ); ?>" target="_blank"><?php esc_html_e('Service Section','makeup-artist'); ?></a>
								</div>
							</div>
						
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','makeup-artist'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','makeup-artist'); ?></a>
								</div>
							</div>
							
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','makeup-artist'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','makeup-artist'); ?></a>
								</div>
							</div>
						</div>
					</div>
			  	</div>
				<div class="col-right-inner">
					<h3 class="page-template"><?php esc_html_e('How to set up Home Page Template','makeup-artist'); ?></h3>
				  	<hr class="h3hr">
					<p><?php esc_html_e('Follow these instructions to setup Home page.','makeup-artist'); ?></p>
                  	<p><span class="strong"><?php esc_html_e('1. Create a new page :','makeup-artist'); ?></span><?php esc_html_e(' Go to ','makeup-artist'); ?>
					  	<b><?php esc_html_e(' Dashboard >> Pages >> Add New Page','makeup-artist'); ?></b></p>
                  	<p><?php esc_html_e('Name it as "Home" then select the template "Custom Home Page".','makeup-artist'); ?></p>
                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/home-page-template.png" alt="" />
                  	<p><span class="strong"><?php esc_html_e('2. Set the front page:','makeup-artist'); ?></span><?php esc_html_e(' Go to ','makeup-artist'); ?>
					  	<b><?php esc_html_e(' Settings >> Reading ','makeup-artist'); ?></b></p>
				  	<p><?php esc_html_e('Select the option of Static Page, now select the page you created to be the homepage, while another page to be your default page.','makeup-artist'); ?></p>
                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/set-front-page.png" alt="" />
                  	<p><?php esc_html_e(' Once you are done with setup, then follow the','makeup-artist'); ?> <a class="doc-links" href="<?php echo esc_url( MAKEUP_ARTIST_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','makeup-artist'); ?></a></p>
			  	</div>
			</div>
		</div>

		<div id="block_pattern" class="tabcontent">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
			$plugin_ins = Makeup_Artist_Plugin_Activation_Settings::get_instance();
			$makeup_artist_actions = $plugin_ins->recommended_actions;
			?>
				<div class="makeup-artist-recommended-plugins">
				    <div class="makeup-artist-action-list">
				        <?php if ($makeup_artist_actions): foreach ($makeup_artist_actions as $key => $makeup_artist_actionValue): ?>
				                <div class="makeup-artist-action" id="<?php echo esc_attr($makeup_artist_actionValue['id']);?>">
			                        <div class="action-inner">
			                            <h3 class="action-title"><?php echo esc_html($makeup_artist_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($makeup_artist_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($makeup_artist_actionValue['link']); ?>
			                            <a class="ibtana-skip-btn" href="javascript:void(0);" get-start-tab-id="gutenberg-editor-tab"><?php esc_html_e('Skip','makeup-artist'); ?></a>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php } ?>
			<div class="gutenberg-editor-tab" style="<?php echo esc_attr($makeup_artist_plugin_custom_css); ?>">
				<div class="block-pattern-img">
				  	<h3><?php esc_html_e( 'Block Patterns', 'makeup-artist' ); ?></h3>
					<hr class="h3hr">
					<p><?php esc_html_e('Follow the below instructions to setup Home page with Block Patterns.','makeup-artist'); ?></p>
	              	<p><b><?php esc_html_e('Click on Below Add new page button >> Click on "+" Icon >> Click Pattern Tab >> Click on homepage sections >> Publish.','makeup-artist'); ?></span></b></p>
	              	<div class="makeup-artist-pattern-page">
				    	<a href="javascript:void(0)" class="vw-pattern-page-btn button-primary button"><?php esc_html_e('Add New Page','makeup-artist'); ?></a>
				    </div>
	              	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/block-pattern.png" alt="" />
	            </div>

	            <div class="block-pattern-link-customizer">
					<h3><?php esc_html_e( 'Link to customizer', 'makeup-artist' ); ?></h3>
					<hr class="h3hr">
					<div class="first-row">
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','makeup-artist'); ?></a>
							</div>
							<div class="row-box2">
								<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','makeup-artist'); ?></a>
							</div>
						</div>
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','makeup-artist'); ?></a>
							</div>
							
							<div class="row-box2">
								<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','makeup-artist'); ?></a>
							</div>
						</div>
						
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','makeup-artist'); ?></a>
							</div>
							 <div class="row-box2">
								<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','makeup-artist'); ?></a>
							</div> 
						</div>
					</div>
				</div>		
					
	        </div>
		</div>
		
		<div id="gutenberg_editor" class="tabcontent">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
			$plugin_ins = Makeup_Artist_Plugin_Activation_Settings::get_instance();
			$makeup_artist_actions = $plugin_ins->recommended_actions;
			?>
				<div class="makeup-artist-recommended-plugins">
				    <div class="makeup-artist-action-list">
				        <?php if ($makeup_artist_actions): foreach ($makeup_artist_actions as $key => $makeup_artist_actionValue): ?>
				                <div class="makeup-artist-action" id="<?php echo esc_attr($makeup_artist_actionValue['id']);?>">
			                        <div class="action-inner plugin-activation-redirect">
			                            <h3 class="action-title"><?php echo esc_html($makeup_artist_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($makeup_artist_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($makeup_artist_actionValue['link']); ?>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php }else{ ?>
				<h3><?php esc_html_e( 'Gutunberg Blocks', 'makeup-artist' ); ?></h3>
				<hr class="h3hr">
				<div class="makeup-artist-pattern-page">
			    	<a href="<?php echo esc_url( admin_url( 'admin.php?page=ibtana-visual-editor-templates' ) ); ?>" class="vw-pattern-page-btn ibtana-dashboard-page-btn button-primary button"><?php esc_html_e('Ibtana Settings','makeup-artist'); ?></a>
			    </div>

			    <div class="link-customizer-with-guternberg-ibtana">
	              	<div class="link-customizer-with-block-pattern">
						<h3><?php esc_html_e( 'Link to customizer', 'makeup-artist' ); ?></h3>
						<hr class="h3hr">
						<div class="first-row">
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','makeup-artist'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','makeup-artist'); ?></a>
								</div>
							</div>
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','makeup-artist'); ?></a>
								</div>
								
								<div class="row-box2">
									<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','makeup-artist'); ?></a>
								</div>
							</div>
							
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=makeup_artist_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','makeup-artist'); ?></a>
								</div>
								 <div class="row-box2">
									<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','makeup-artist'); ?></a>
								</div> 
							</div>
						</div>
					</div>	
				</div>
			<?php } ?>
		</div>

		<div id="product_addons_editor" class="tabcontent">
			<?php if(!class_exists('IEPA_Loader')){
				$plugin_ins = Makeup_Artist_Plugin_Activation_Woo_Products::get_instance();
				$makeup_artist_actions = $plugin_ins->recommended_actions;
				?>
				<div class="makeup-artist-recommended-plugins">
					    <div class="makeup-artist-action-list">
					        <?php if ($makeup_artist_actions): foreach ($makeup_artist_actions as $key => $makeup_artist_actionValue): ?>
					                <div class="makeup-artist-action" id="<?php echo esc_attr($makeup_artist_actionValue['id']);?>">
				                        <div class="action-inner plugin-activation-redirect">
				                            <h3 class="action-title"><?php echo esc_html($makeup_artist_actionValue['title']); ?></h3>
				                            <div class="action-desc"><?php echo esc_html($makeup_artist_actionValue['desc']); ?></div>
				                            <?php echo wp_kses_post($makeup_artist_actionValue['link']); ?>
				                        </div>
					                </div>
					            <?php endforeach;
					        endif; ?>
					    </div>
				</div>
			<?php }else{ ?>
				<h3><?php esc_html_e( 'Woocommerce Products Blocks', 'makeup-artist' ); ?></h3>
				<hr class="h3hr">
				<div class="makeup-artist-pattern-page">
					<p><?php esc_html_e('Follow the below instructions to setup Products Templates.','makeup-artist'); ?></p>
					<p><b><?php esc_html_e('1. First you need to activate these plugins','makeup-artist'); ?></b></p>
						<p><?php esc_html_e('1. Ibtana - WordPress Website Builder ','makeup-artist'); ?></p>
						<p><?php esc_html_e('2. Ibtana - Ecommerce Product Addons.','makeup-artist'); ?></p>
						<p><?php esc_html_e('3. Woocommerce','makeup-artist'); ?></p>

					<p><b><?php esc_html_e('2. Go To Dashboard >> Ibtana Settings >> Woocommerce Templates','makeup-artist'); ?></span></b></p>
	              	<div class="makeup-artist-pattern-page">
			    		<a href="<?php echo esc_url( admin_url( 'admin.php?page=ibtana-visual-editor-woocommerce-templates&ive_wizard_view=parent' ) ); ?>" class="vw-pattern-page-btn ibtana-dashboard-page-btn button-primary button"><?php esc_html_e('Woocommerce Templates','makeup-artist'); ?></a>
			    	</div>
	              	<p><?php esc_html_e('You can create a template as you like.','makeup-artist'); ?></span></p>
			    </div>
			<?php } ?>
		</div>

		<div id="theme_pro" class="tabcontent">
		  	<h3><?php esc_html_e( 'Premium Theme Information', 'makeup-artist' ); ?></h3>
			<hr class="h3hr">
		    <div class="col-left-pro">
		    	<p><?php esc_html_e('In order to ensure that your website makes a strong first impression of your work as a makeup artist, you have this Makeup Artist WordPress Theme. It has a professionally designed layout that is capable of making clients come back to your page. You can use its incredible layout to boost your makeup brand. The flawless slider puts enticing images of your work to display that quickly grabs the attention of the audience well-placed Call To Action Buttons (CTA) guide them to explore more and take necessary steps. WP Makeup Artist WordPress Theme shares your portfolio well and emphasizes your expertise by giving them a proper space on your web page. You cannot miss the wonderful animations added to the page that will pop up as your visitors scroll down the page. The SEO-optimized design will always let you grab better SEO ranks and eventually, get more visitors to your site.','makeup-artist'); ?></p>
		    	<div class="pro-links">
			    	<a href="<?php echo esc_url( MAKEUP_ARTIST_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'makeup-artist'); ?></a>
					<a href="<?php echo esc_url( MAKEUP_ARTIST_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'makeup-artist'); ?></a>
					<a href="<?php echo esc_url( MAKEUP_ARTIST_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'makeup-artist'); ?></a>
				</div>
		    </div>
		    <div class="col-right-pro">
		    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/responsive.png" alt="" />
		    </div>
		    <div class="featurebox">
			    <h3><?php esc_html_e( 'Theme Features', 'makeup-artist' ); ?></h3>
				<hr class="h3hr">
				<div class="table-image">
					<table class="tablebox">
						<thead>
							<tr>
								<th></th>
								<th><?php esc_html_e('Free Themes', 'makeup-artist'); ?></th>
								<th><?php esc_html_e('Premium Themes', 'makeup-artist'); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e('Theme Customization', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Responsive Design', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Logo Upload', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Social Media Links', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Slider Settings', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Number of Slides', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('4', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('Unlimited', 'makeup-artist'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Template Pages', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('3', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('6', 'makeup-artist'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Home Page Template', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'makeup-artist'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Theme sections', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('2', 'makeup-artist'); ?></td>
								<td class="table-img"><?php esc_html_e('13', 'makeup-artist'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Contact us Page Template', 'makeup-artist'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('1', 'makeup-artist'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Blog Templates & Layout', 'makeup-artist'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'makeup-artist'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Page Templates & Layout', 'makeup-artist'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('2(Left/Right Sidebar)', 'makeup-artist'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Color Pallete For Particular Sections', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Global Color Option', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Reordering', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Demo Importer', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Allow To Set Site Title, Tagline, Logo', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Enable Disable Options On All Sections, Logo', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Full Documentation', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Latest WordPress Compatibility', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Woo-Commerce Compatibility', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Support 3rd Party Plugins', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Secure and Optimized Code', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Exclusive Functionalities', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Enable / Disable', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Google Font Choices', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Gallery', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Simple & Mega Menu Option', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support to add custom CSS / JS ', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Shortcodes', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Premium Membership', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Budget Friendly Value', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Priority Error Fixing', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Feature Addition', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('All Access Theme Pass', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Seamless Customer Support', 'makeup-artist'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td></td>
								<td class="table-img"></td>
								<td class="update-link"><a href="<?php echo esc_url( MAKEUP_ARTIST_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade to Pro', 'makeup-artist'); ?></a></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div id="free_pro" class="tabcontent">
		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-star-filled"></span><?php esc_html_e('Pro Version', 'makeup-artist'); ?></h4>
				<p> <?php esc_html_e('To gain access to extra theme options and more interesting features, upgrade to pro version.', 'makeup-artist'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( MAKEUP_ARTIST_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'makeup-artist'); ?></a>
				</div>
		  	</div>
		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-cart"></span><?php esc_html_e('Pre-purchase Queries', 'makeup-artist'); ?></h4>
				<p> <?php esc_html_e('If you have any pre-sale query, we are prepared to resolve it.', 'makeup-artist'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( MAKEUP_ARTIST_CONTACT ); ?>" target="_blank"><?php esc_html_e('Question', 'makeup-artist'); ?></a>
				</div>
		  	</div>
		  	<div class="col-3">		  		
		  		<h4><span class="dashicons dashicons-admin-customizer"></span><?php esc_html_e('Child Theme', 'makeup-artist'); ?></h4>
				<p> <?php esc_html_e('For theme file customizations, make modifications in the child theme and not in the main theme file.', 'makeup-artist'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( MAKEUP_ARTIST_CHILD_THEME ); ?>" target="_blank"><?php esc_html_e('About Child Theme', 'makeup-artist'); ?></a>
				</div>
		  	</div>

		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-admin-comments"></span><?php esc_html_e('Frequently Asked Questions', 'makeup-artist'); ?></h4>
				<p> <?php esc_html_e('We have gathered top most, frequently asked questions and answered them for your easy understanding. We will list down more as we get new challenging queries. Check back often.', 'makeup-artist'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( MAKEUP_ARTIST_FAQ ); ?>" target="_blank"><?php esc_html_e('View FAQ','makeup-artist'); ?></a>
				</div>
		  	</div>

		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-sos"></span><?php esc_html_e('Support Queries', 'makeup-artist'); ?></h4>
				<p> <?php esc_html_e('If you have any queries after purchase, you can contact us. We are eveready to help you out.', 'makeup-artist'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( MAKEUP_ARTIST_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Contact Us', 'makeup-artist'); ?></a>
				</div>
		  	</div>
		</div>

	</div>
</div>

<?php } ?>