<?php
/**
 * Makeup Artist Theme Customizer
 *
 * @package Makeup Artist
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function makeup_artist_custom_controls() {
	load_template( trailingslashit( get_template_directory() ) . '/inc/custom-controls.php' );
}
add_action( 'customize_register', 'makeup_artist_custom_controls' );

function makeup_artist_customize_register( $wp_customize ) {

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage'; 
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array( 
		'selector' => '.logo .site-title a', 
	 	'render_callback' => 'makeup_artist_Customize_partial_blogname',
	)); 

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array( 
		'selector' => 'p.site-description', 
		'render_callback' => 'makeup_artist_Customize_partial_blogdescription',
	));

	// add home page setting pannel
	$wp_customize->add_panel( 'makeup_artist_panel_id', array(
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__( 'VW Settings', 'makeup-artist' ),
		'priority' => 10,
	));

	// Layout
	$wp_customize->add_section( 'makeup_artist_left_right', array(
    	'title' => esc_html__( 'General Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_panel_id'
	) );

	$wp_customize->add_setting('makeup_artist_width_option',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control(new Makeup_Artist_Image_Radio_Control($wp_customize, 'makeup_artist_width_option', array(
        'type' => 'select',
        'label' => esc_html__('Width Layouts','makeup-artist'),
        'description' => esc_html__('Here you can change the width layout of Website.','makeup-artist'),
        'section' => 'makeup_artist_left_right',
        'choices' => array(
            'Full Width' => esc_url(get_template_directory_uri()).'/assets/images/full-width.png',
            'Wide Width' => esc_url(get_template_directory_uri()).'/assets/images/wide-width.png',
            'Boxed' => esc_url(get_template_directory_uri()).'/assets/images/boxed-width.png',
    ))));

	$wp_customize->add_setting('makeup_artist_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control('makeup_artist_theme_options',array(
        'type' => 'select',
        'label' => esc_html__('Post Sidebar Layout','makeup-artist'),
        'description' => esc_html__('Here you can change the sidebar layout for posts. ','makeup-artist'),
        'section' => 'makeup_artist_left_right',
        'choices' => array(
            'Left Sidebar' => esc_html__('Left Sidebar','makeup-artist'),
            'Right Sidebar' => esc_html__('Right Sidebar','makeup-artist'),
            'One Column' => esc_html__('One Column','makeup-artist'),
            'Grid Layout' => esc_html__('Grid Layout','makeup-artist')
        ),
	) );

	$wp_customize->add_setting('makeup_artist_page_layout',array(
        'default' => 'One_Column',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control('makeup_artist_page_layout',array(
        'type' => 'select',
        'label' => esc_html__('Page Sidebar Layout','makeup-artist'),
        'description' => esc_html__('Here you can change the sidebar layout for pages. ','makeup-artist'),
        'section' => 'makeup_artist_left_right',
        'choices' => array(
            'Left_Sidebar' => esc_html__('Left Sidebar','makeup-artist'),
            'Right_Sidebar' => esc_html__('Right Sidebar','makeup-artist'),
            'One_Column' => esc_html__('One Column','makeup-artist')
        ),
	) );

	// Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'makeup_artist_woocommerce_shop_page_sidebar', array( 'selector' => '.post-type-archive-product #sidebar', 
		'render_callback' => 'makeup_artist_customize_partial_makeup_artist_woocommerce_shop_page_sidebar', ) );

    // Woocommerce Shop Page Sidebar
	$wp_customize->add_setting( 'makeup_artist_woocommerce_shop_page_sidebar',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_woocommerce_shop_page_sidebar',array(
		'label' => esc_html__( 'Shop Page Sidebar','makeup-artist' ),
		'section' => 'makeup_artist_left_right'
    )));

    // Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'makeup_artist_woocommerce_single_product_page_sidebar', array( 'selector' => '.single-product #sidebar', 
		'render_callback' => 'makeup_artist_customize_partial_makeup_artist_woocommerce_single_product_page_sidebar', ) );

    //Woocommerce Single Product page Sidebar
	$wp_customize->add_setting( 'makeup_artist_woocommerce_single_product_page_sidebar',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_woocommerce_single_product_page_sidebar',array(
		'label' => esc_html__( 'Single Product Sidebar','makeup-artist' ),
		'section' => 'makeup_artist_left_right'
    )));

    // Pre-Loader
	$wp_customize->add_setting( 'makeup_artist_loader_enable',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_loader_enable',array(
        'label' => esc_html__( 'Pre-Loader','makeup-artist' ),
        'section' => 'makeup_artist_left_right'
    )));

	$wp_customize->add_setting('makeup_artist_preloader_bg_color', array(
		'default'           => '#272b36',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'makeup_artist_preloader_bg_color', array(
		'label'    => __('Pre-Loader Background Color', 'makeup-artist'),
		'section'  => 'makeup_artist_left_right',
	)));

	$wp_customize->add_setting('makeup_artist_preloader_border_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'makeup_artist_preloader_border_color', array(
		'label'    => __('Pre-Loader Border Color', 'makeup-artist'),
		'section'  => 'makeup_artist_left_right',
	)));

	// Top Bar
	$wp_customize->add_section( 'makeup_artist_topbar' , array(
    	'title' => esc_html__( 'Top Bar', 'makeup-artist' ),
		'panel' => 'makeup_artist_panel_id'
	) );

	$wp_customize->add_setting('makeup_artist_phone_number',array(
		'default'=> '',
		'sanitize_callback'	=> 'makeup_artist_sanitize_phone_number'
	));
	$wp_customize->add_control('makeup_artist_phone_number',array(
		'label'	=> esc_html__('Add Phone Number','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( '123 456 7890', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_phone_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_phone_text',array(
		'label'	=> esc_html__('Add Phone Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'PHONE', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_timing',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_timing',array(
		'label'	=> esc_html__('Add Timing','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Mon-Sat 11am-6pm', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_timing_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_timing_text',array(
		'label'	=> esc_html__('Add Timing Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'TIMING', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_email_address',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('makeup_artist_email_address',array(
		'label'	=> esc_html__('Add Email Address','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'example@gmail.com', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_email_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_email_text',array(
		'label'	=> esc_html__('Add Email Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'EMAIL', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_appointment_btn_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_appointment_btn_text',array(
		'label'	=> esc_html__('Add Button Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'BOOK AN APPOINTMENT', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_appointment_btn_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('makeup_artist_appointment_btn_url',array(
		'label'	=> esc_html__('Add Button URL','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'www.example.com', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_topbar',
		'type'=> 'url'
	));

	//Slider
	$wp_customize->add_section( 'makeup_artist_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_panel_id'
	) );

	$wp_customize->add_setting( 'makeup_artist_slider_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_slider_hide_show',array(
      'label' => esc_html__( 'Show / Hide Slider','makeup-artist' ),
      'section' => 'makeup_artist_slidersettings'
    )));

     //Selective Refresh
    $wp_customize->selective_refresh->add_partial('makeup_artist_slider_hide_show',array(
		'selector'        => '.slider-btn a',
		'render_callback' => 'makeup_artist_customize_partial_makeup_artist_slider_hide_show',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'makeup_artist_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'makeup_artist_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'makeup_artist_slider_page' . $count, array(
			'label'    => __( 'Select Slider Page', 'makeup-artist' ),
			'description' => __('Slider image size (1500 x 600)','makeup-artist'),
			'section'  => 'makeup_artist_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('makeup_artist_quote_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_quote_text',array(
		'label'	=> esc_html__('Add Quote Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Need a quick quote? We can help!', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_slidersettings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_quote_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('makeup_artist_quote_link',array(
		'label'	=> esc_html__('Add Quote Link','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'www.example.com', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_slidersettings',
		'type'=> 'url'
	));

	$wp_customize->add_setting( 'makeup_artist_slider_title_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_slider_title_hide_show',array(
		'label' => esc_html__( 'Show / Hide Slider Title','makeup-artist' ),
		'section' => 'makeup_artist_slidersettings'
    )));

	$wp_customize->add_setting( 'makeup_artist_slider_content_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_slider_content_hide_show',array(
		'label' => esc_html__( 'Show / Hide Slider Content','makeup-artist' ),
		'section' => 'makeup_artist_slidersettings'
    )));

	//content layout
	$wp_customize->add_setting('makeup_artist_slider_content_option',array(
        'default' => 'Left',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control(new Makeup_Artist_Image_Radio_Control($wp_customize, 'makeup_artist_slider_content_option', array(
        'type' => 'select',
        'label' => __('Slider Content Layouts','makeup-artist'),
        'section' => 'makeup_artist_slidersettings',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/slider-content1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/slider-content2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/slider-content3.png',
    ))));

    //Slider excerpt
	$wp_customize->add_setting( 'makeup_artist_slider_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'makeup_artist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'makeup_artist_slider_excerpt_number', array(
		'label'       => esc_html__( 'Slider Excerpt length','makeup-artist' ),
		'section'     => 'makeup_artist_slidersettings',
		'type'        => 'range',
		'settings'    => 'makeup_artist_slider_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Opacity
	$wp_customize->add_setting('makeup_artist_slider_opacity_color',array(
		'default'              => 0.7,
		'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));

	$wp_customize->add_control( 'makeup_artist_slider_opacity_color', array(
		'label'       => esc_html__( 'Slider Image Opacity','makeup-artist' ),
		'section'     => 'makeup_artist_slidersettings',
		'type'        => 'select',
		'settings'    => 'makeup_artist_slider_opacity_color',
		'choices' => array(
			'0' =>  esc_attr('0','makeup-artist'),
			'0.1' =>  esc_attr('0.1','makeup-artist'),
			'0.2' =>  esc_attr('0.2','makeup-artist'),
			'0.3' =>  esc_attr('0.3','makeup-artist'),
			'0.4' =>  esc_attr('0.4','makeup-artist'),
			'0.5' =>  esc_attr('0.5','makeup-artist'),
			'0.6' =>  esc_attr('0.6','makeup-artist'),
			'0.7' =>  esc_attr('0.7','makeup-artist'),
			'0.8' =>  esc_attr('0.8','makeup-artist'),
			'0.9' =>  esc_attr('0.9','makeup-artist')
		),
	));

	//Slider height
	$wp_customize->add_setting('makeup_artist_slider_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_slider_height',array(
		'label'	=> __('Slider Height','makeup-artist'),
		'description'	=> __('Specify the slider height (px).','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( '500px', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_slidersettings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'makeup_artist_slider_speed', array(
		'default'  => 4000,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'makeup_artist_slider_speed', array(
		'label' => esc_html__('Slider Transition Speed','makeup-artist'),
		'section' => 'makeup_artist_slidersettings',
		'type'  => 'text',
	) );

	// Services Section
	$wp_customize->add_section('makeup_artist_service_section',array(
		'title'	=> __('Service Section','makeup-artist'),
		'description' => __('Add section title and Select the Category to display for services.','makeup-artist'),
		'panel' => 'makeup_artist_panel_id',
	));

	$wp_customize->add_setting( 'makeup_artist_section_small_title', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'makeup_artist_section_small_title', array(
		'label'    => __( 'Add Section Small Title', 'makeup-artist' ),
		'input_attrs' => array(
            'placeholder' => __( 'OUR SERVICES', 'makeup-artist' ),
        ),
		'section'  => 'makeup_artist_service_section',
		'type'     => 'text'
	) );

	$wp_customize->add_setting( 'makeup_artist_section_title', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'makeup_artist_section_title', array(
		'label'    => __( 'Add Section Title', 'makeup-artist' ),
		'input_attrs' => array(
            'placeholder' => __( 'We Provide Nothing but the best!', 'makeup-artist' ),
        ),
		'section'  => 'makeup_artist_service_section',
		'type'     => 'text'
	) );

	$wp_customize->add_setting( 'makeup_artist_section_text', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'makeup_artist_section_text', array(
		'label'    => __( 'Add Section Text', 'makeup-artist' ),
		'input_attrs' => array(
            'placeholder' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'makeup-artist' ),
        ),
		'section'  => 'makeup_artist_service_section',
		'type'     => 'text'
	) );

	$categories = get_categories();
		$cat_posts = array();
			$i = 0;
			$cat_posts[]='Select';
		foreach($categories as $category){
			if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('makeup_artist_service_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'makeup_artist_sanitize_choices',
	));
	$wp_customize->add_control('makeup_artist_service_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select Service Category Category','makeup-artist'),
		'description' => __('Image size (150px x 180px)','makeup-artist'),
		'section' => 'makeup_artist_service_section',
	));

	//Blog Post
	$wp_customize->add_panel( 'makeup_artist_blog_post_parent_panel', array(
		'title' => esc_html__( 'Blog Post Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_panel_id',
		'priority' => 20,
	));

	// Add example section and controls to the middle (second) panel
	$wp_customize->add_section( 'makeup_artist_post_settings', array(
		'title' => esc_html__( 'Post Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('makeup_artist_toggle_postdate', array( 
		'selector' => '.post-main-box h2 a', 
		'render_callback' => 'makeup_artist_Customize_partial_makeup_artist_toggle_postdate', 
	));

	$wp_customize->add_setting( 'makeup_artist_toggle_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_toggle_postdate',array(
        'label' => esc_html__( 'Post Date','makeup-artist' ),
        'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_toggle_author',array(
		'label' => esc_html__( 'Author','makeup-artist' ),
		'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_toggle_comments',array(
		'label' => esc_html__( 'Comments','makeup-artist' ),
		'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_toggle_time',array(
		'label' => esc_html__( 'Time','makeup-artist' ),
		'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_featured_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
	));
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_featured_image_hide_show', array(
		'label' => esc_html__( 'Featured Image','makeup-artist' ),
		'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_toggle_tags',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
	));
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_toggle_tags', array(
		'label' => esc_html__( 'Tags','makeup-artist' ),
		'section' => 'makeup_artist_post_settings'
    )));

    $wp_customize->add_setting( 'makeup_artist_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'makeup_artist_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'makeup_artist_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','makeup-artist' ),
		'section'     => 'makeup_artist_post_settings',
		'type'        => 'range',
		'settings'    => 'makeup_artist_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('makeup_artist_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','makeup-artist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','makeup-artist'),
		'section'=> 'makeup_artist_post_settings',
		'type'=> 'text'
	));

    $wp_customize->add_setting('makeup_artist_excerpt_settings',array(
        'default' => 'Excerpt',
        'transport' => 'refresh',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control('makeup_artist_excerpt_settings',array(
        'type' => 'select',
        'label' => esc_html__('Post Content','makeup-artist'),
        'section' => 'makeup_artist_post_settings',
        'choices' => array(
        	'Content' => esc_html__('Content','makeup-artist'),
            'Excerpt' => esc_html__('Excerpt','makeup-artist'),
            'No Content' => esc_html__('No Content','makeup-artist')
        ),
	) );

    // Button Settings
	$wp_customize->add_section( 'makeup_artist_button_settings', array(
		'title' => esc_html__( 'Button Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_blog_post_parent_panel',
	));

	$wp_customize->add_setting( 'makeup_artist_button_border_radius', array(
		'default'              => 5,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'makeup_artist_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'makeup_artist_button_border_radius', array(
		'label'       => esc_html__( 'Button Border Radius','makeup-artist' ),
		'section'     => 'makeup_artist_button_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('makeup_artist_button_text', array( 
		'selector' => '.post-main-box .more-btn a', 
		'render_callback' => 'makeup_artist_Customize_partial_makeup_artist_button_text', 
	));

    $wp_customize->add_setting('makeup_artist_button_text',array(
		'default'=> esc_html__('Read More','makeup-artist'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_button_text',array(
		'label'	=> esc_html__('Add Button Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Read More', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_button_settings',
		'type'=> 'text'
	));

	// Related Post Settings
	$wp_customize->add_section( 'makeup_artist_related_posts_settings', array(
		'title' => esc_html__( 'Related Posts Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('makeup_artist_related_post_title', array( 
		'selector' => '.related-post h3', 
		'render_callback' => 'makeup_artist_Customize_partial_makeup_artist_related_post_title', 
	));

    $wp_customize->add_setting( 'makeup_artist_related_post',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ) );
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_related_post',array(
		'label' => esc_html__( 'Related Post','makeup-artist' ),
		'section' => 'makeup_artist_related_posts_settings'
    )));

    $wp_customize->add_setting('makeup_artist_related_post_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_related_post_title',array(
		'label'	=> esc_html__('Add Related Post Title','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Related Post', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_related_posts_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('makeup_artist_related_posts_count',array(
		'default'=> 3,
		'sanitize_callback'	=> 'makeup_artist_sanitize_number_absint'
	));
	$wp_customize->add_control('makeup_artist_related_posts_count',array(
		'label'	=> esc_html__('Add Related Post Count','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( '3', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_related_posts_settings',
		'type'=> 'number'
	));

	// Single Posts Settings
	$wp_customize->add_section( 'makeup_artist_single_blog_settings', array(
		'title' => __( 'Single Post Settings', 'makeup-artist' ),
		'panel' => 'makeup_artist_blog_post_parent_panel',
	));

	$wp_customize->add_setting('makeup_artist_single_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_single_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','makeup-artist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','makeup-artist'),
		'section'=> 'makeup_artist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_single_blog_comment_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('makeup_artist_single_blog_comment_title',array(
		'label'	=> __('Add Comment Title','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( 'Leave a Reply', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_single_blog_comment_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('makeup_artist_single_blog_comment_button_text',array(
		'label'	=> __('Add Comment Button Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( 'Post Comment', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_single_blog_comment_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_single_blog_comment_width',array(
		'label'	=> __('Comment Form Width','makeup-artist'),
		'description'	=> __('Enter a value in %. Example:50%','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( '100%', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_single_blog_settings',
		'type'=> 'text'
	));

	//Responsive Media Settings
	$wp_customize->add_section('makeup_artist_responsive_media',array(
		'title'	=> esc_html__('Responsive Media','makeup-artist'),
		'panel' => 'makeup_artist_panel_id',
	));

    $wp_customize->add_setting( 'makeup_artist_resp_slider_hide_show',array(
      	'default' => 0,
     	'transport' => 'refresh',
      	'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_resp_slider_hide_show',array(
      	'label' => esc_html__( 'Show / Hide Slider','makeup-artist' ),
      	'section' => 'makeup_artist_responsive_media'
    )));

    $wp_customize->add_setting( 'makeup_artist_sidebar_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_sidebar_hide_show',array(
      	'label' => esc_html__( 'Show / Hide Sidebar','makeup-artist' ),
      	'section' => 'makeup_artist_responsive_media'
    )));

    $wp_customize->add_setting( 'makeup_artist_resp_scroll_top_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_resp_scroll_top_hide_show',array(
      	'label' => esc_html__( 'Show / Hide Scroll To Top','makeup-artist' ),
      	'section' => 'makeup_artist_responsive_media'
    )));

	//Footer Text
	$wp_customize->add_section('makeup_artist_footer',array(
		'title'	=> esc_html__('Footer Settings','makeup-artist'),
		'panel' => 'makeup_artist_panel_id',
	));	

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('makeup_artist_footer_text', array( 
		'selector' => '.copyright p', 
		'render_callback' => 'makeup_artist_Customize_partial_makeup_artist_footer_text', 
	));
	
	$wp_customize->add_setting('makeup_artist_footer_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('makeup_artist_footer_text',array(
		'label'	=> esc_html__('Copyright Text','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Copyright 2021, .....', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_copyright_alingment',array(
        'default' => 'center',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control(new Makeup_Artist_Image_Radio_Control($wp_customize, 'makeup_artist_copyright_alingment', array(
        'type' => 'select',
        'label' => esc_html__('Copyright Alignment','makeup-artist'),
        'section' => 'makeup_artist_footer',
        'settings' => 'makeup_artist_copyright_alingment',
        'choices' => array(
            'left' => esc_url(get_template_directory_uri()).'/assets/images/copyright1.png',
            'center' => esc_url(get_template_directory_uri()).'/assets/images/copyright2.png',
            'right' => esc_url(get_template_directory_uri()).'/assets/images/copyright3.png'
    ))));

    $wp_customize->add_setting( 'makeup_artist_hide_show_scroll',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'makeup_artist_switch_sanitization'
    ));  
    $wp_customize->add_control( new Makeup_Artist_Toggle_Switch_Custom_Control( $wp_customize, 'makeup_artist_hide_show_scroll',array(
      	'label' => esc_html__( 'Show / Hide Scroll to Top','makeup-artist' ),
      	'section' => 'makeup_artist_footer'
    )));

     //Selective Refresh
	$wp_customize->selective_refresh->add_partial('makeup_artist_scroll_to_top_icon', array( 
		'selector' => '.scrollup i', 
		'render_callback' => 'makeup_artist_Customize_partial_makeup_artist_scroll_to_top_icon', 
	));

    $wp_customize->add_setting('makeup_artist_scroll_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'makeup_artist_sanitize_choices'
	));
	$wp_customize->add_control(new Makeup_Artist_Image_Radio_Control($wp_customize, 'makeup_artist_scroll_top_alignment', array(
        'type' => 'select',
        'label' => esc_html__('Scroll To Top','makeup-artist'),
        'section' => 'makeup_artist_footer',
        'settings' => 'makeup_artist_scroll_top_alignment',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/layout2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout3.png'
    ))));

    //Woocommerce settings
	$wp_customize->add_section('makeup_artist_woocommerce_section', array(
		'title'    => __('WooCommerce Layout', 'makeup-artist'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

    $wp_customize->add_setting('makeup_artist_products_btn_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_products_btn_padding_top_bottom',array(
		'label'	=> __('Products Button Padding Top Bottom','makeup-artist'),
		'description'	=> __('Enter a value in pixels. Example:20px','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('makeup_artist_products_btn_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('makeup_artist_products_btn_padding_left_right',array(
		'label'	=> __('Products Button Padding Left Right','makeup-artist'),
		'description'	=> __('Enter a value in pixels. Example:20px','makeup-artist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'makeup-artist' ),
        ),
		'section'=> 'makeup_artist_woocommerce_section',
		'type'=> 'text'
	));
}

add_action( 'customize_register', 'makeup_artist_customize_register' );

load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Makeup_Artist_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Makeup_Artist_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section( new Makeup_Artist_Customize_Section_Pro( $manager,'makeup_artist_go_pro', array(
			'priority'   => 1,
			'title'    => esc_html__( 'MAKEUP ARTIST PRO', 'makeup-artist' ),
			'pro_text' => esc_html__( 'UPGRADE PRO', 'makeup-artist' ),
			'pro_url'  => esc_url('https://www.vwthemes.com/themes/makeup-artist-wordpress-theme/'),
		) )	);

		// Register sections.
		$manager->add_section(new Makeup_Artist_Customize_Section_Pro($manager,'makeup_artist_get_started_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'DOCUMENTATION', 'makeup-artist' ),
			'pro_text' => esc_html__( 'DOCS', 'makeup-artist' ),
			'pro_url'  => admin_url('themes.php?page=makeup_artist_guide'),
		)));
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'makeup-artist-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'makeup-artist-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Makeup_Artist_Customize::get_instance();