<?php
/**
 * @package Makeup Artist
 * Setup the WordPress core custom header feature.
 *
 * @uses makeup_artist_header_style()
*/
function makeup_artist_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'makeup_artist_custom_header_args', array(
		'header-text' 			 =>	false,
		'width'                  => 1000,
		'height'                 => 75,
		'flex-width'    		 => true,
		'flex-height'    		 => true,
		'wp-head-callback'       => 'makeup_artist_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'makeup_artist_custom_header_setup' );

if ( ! function_exists( 'makeup_artist_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see makeup_artist_custom_header_setup().
 */
add_action( 'wp_enqueue_scripts', 'makeup_artist_header_style' );

function makeup_artist_header_style() {
	if ( get_header_image() ) :
	$custom_css = "
        .top-header{
			background-image:url('".esc_url(get_header_image())."');
			background-position: center top;
		    background-size: 100% 100%;
		}";
	   	wp_add_inline_style( 'makeup-artist-basic-style', $custom_css );
	endif;
}
endif;