<?php
/**
 *  Makeup Artist: Block Patterns
 *
 * @package Makeup Artist
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'makeup-artist',
		array( 'label' => __( 'Makeup Artist', 'makeup-artist' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'makeup-artist/banner-section',
		array(
			'title'      => __( 'Banner Section', 'makeup-artist' ),
			'categories' => array( 'makeup-artist' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\",\"id\":1254,\"dimRatio\":0,\"focalPoint\":{\"x\":\"0.39\",\"y\":\"0.54\"},\"isDark\":false,\"align\":\"full\",\"className\":\"slider-section\"} -->\n<div class=\"wp-block-cover alignfull is-light slider-section\"><span aria-hidden=\"true\" class=\"has-background-dim-0 wp-block-cover__gradient-background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1254\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\" style=\"object-position:39% 54%\" data-object-fit=\"cover\" data-object-position=\"39% 54%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\",\"className\":\"mx-5\"} -->\n<div class=\"wp-block-columns alignwide mx-5\"><!-- wp:column {\"className\":\"slider-section1 ps-lg-5 mx-lg-5\"} -->\n<div class=\"wp-block-column slider-section1 ps-lg-5 mx-lg-5\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":1} -->\n<h1 class=\"has-text-align-left\">Flawless!</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem Ipsum has been the industry's standard dummy text </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"slider-section-button\"} -->\n<div class=\"wp-block-buttons slider-section-button\"><!-- wp:button {\"textColor\":\"black\",\"style\":{\"color\":{\"background\":\"#e7c99e\"}},\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" style=\"background-color:#e7c99e\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"slider-section2\"} -->\n<div class=\"wp-block-column slider-section2\"><!-- wp:paragraph {\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\">Need a quick quote? we can help!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'makeup-artist/services-section',
		array(
			'title'      => __( 'Services Section', 'makeup-artist' ),
			'categories' => array( 'makeup-artist' ),
			'content'    => "<!-- wp:group {\"className\":\"services-section\"} -->\n<div class=\"wp-block-group services-section\"><!-- wp:paragraph {\"align\":\"center\",\"className\":\"services-section-content\"} -->\n<p class=\"has-text-align-center services-section-content\">OUR SERVICES</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"className\":\"services-section-heading2\"} -->\n<h2 class=\"has-text-align-center services-section-heading2\">We Provide Nothing But the best!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"services-section-heading3\"} -->\n<p class=\"has-text-align-center services-section-heading3\">simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {\"className\":\"services-section-image-group\"} -->\n<div class=\"wp-block-group services-section-image-group\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"services-section-image-group1\"} -->\n<div class=\"wp-block-column services-section-image-group1\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1296,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"services-section-image1\"} -->\n<figure class=\"wp-block-image size-full services-section-image1\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service1.png\" alt=\"\" class=\"wp-image-1296\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"services-section-post1\"} -->\n<div class=\"wp-block-column services-section-post1\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"has-text-align-left\">Post1</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"black\"} -->\n<p class=\"has-text-align-left has-black-color has-text-color\">READ MORE</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"services-section-image-group2\"} -->\n<div class=\"wp-block-column services-section-image-group2\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1299,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"services-section-image2\"} -->\n<figure class=\"wp-block-image size-full services-section-image2\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service2.png\" alt=\"\" class=\"wp-image-1299\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"services-section-post2\"} -->\n<div class=\"wp-block-column services-section-post2\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"has-text-align-left\">Post2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"black\"} -->\n<p class=\"has-text-align-left has-black-color has-text-color\">READ MORE</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"services-section-image-group3\"} -->\n<div class=\"wp-block-column services-section-image-group3\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1300,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"services-section-image3\"} -->\n<figure class=\"wp-block-image size-full services-section-image3\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service3.png\" alt=\"\" class=\"wp-image-1300\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"services-section-post3\"} -->\n<div class=\"wp-block-column services-section-post3\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"has-text-align-left\">Post3</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"black\"} -->\n<p class=\"has-text-align-left has-black-color has-text-color\">READ MORE</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->",
		)
	);
}